//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections.Generic;
using System.Windows.Forms;

using ircam.jmax.editors.patcher.objects;
using ircam.fts.client;

namespace ircam.jmax
{
    public delegate GraphicObject JMaxObjectCreator(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length);

    internal class ClassMapEntry
    {
        internal ClassMapEntry(string ftsClassName, JMaxObjectCreator creator, string iconName,
                               string selectedIconName, string cursorName, string description,
                               IMaxPackage imaxPackage)
        {
            this.creator = creator;
            if (iconName != null)
                this.icon = iconName;
            if (selectedIconName != null)
                this.selectedIcon = selectedIconName;
            if (cursorName != null)
                this.cursorName = cursorName;
            this.description = description;
        }

        internal ClassMapEntry(string ftsClassName, JMaxObjectCreator creator, string iconPath,
                               string selectedIconPath, string cursorPath, string description)
        {
            this.creator = creator;
            if (iconPath != null)
                this.icon = iconPath;
            if (selectedIconPath != null)
                this.selectedIcon = selectedIconPath;
            if (cursorPath != null)
                this.cursorName = cursorPath;
            this.description = description;
        }

        internal JMaxObjectCreator creator;
        internal string icon, selectedIcon;
        internal string cursorName;
        internal string description;
    }

    public class JMaxClassMap
    {
        public static void Add(string ftsClassName, JMaxObjectCreator creator, string iconName,
                               string selectedIconName, string cursorName, string description,
                               IMaxPackage imaxPackage)
        {
            instance.map.Add(ftsClassName, new ClassMapEntry(ftsClassName, creator, iconName,
                             selectedIconName, cursorName, description, imaxPackage));
            if ((iconName != null) && (cursorName != null) && (selectedIconName != null))
            {
                instance.names.Add(ftsClassName);
            }
        }

        public static void Add(string ftsClassName, JMaxObjectCreator creator, string iconPath,
                               string selectedIconPath, string cursorPath, string description)
        {
            instance.map.Add(ftsClassName, new ClassMapEntry(ftsClassName, creator, iconPath,
                                                             selectedIconPath, cursorPath, description));
            if ((iconPath != null) && (cursorPath != null) && (selectedIconPath != null))
            {
                instance.names.Add(ftsClassName);
            }
        }

        public static void Add(string ftsClassName, JMaxObjectCreator creator, string iconName,
                               string selectedIconName, string description, IMaxPackage imaxPackage)
        {
            Add(ftsClassName, creator, iconName, selectedIconName, null, description, imaxPackage);
        }

        public static void Add(string ftsClassName, JMaxObjectCreator creator, string iconPath,
                               string selectedIconPath, string description)
        {
            Add(ftsClassName, creator, iconPath, selectedIconPath, null, description);
        }

        public static JMaxObjectCreator GetCreator(string ftsClassName)
        {
            if (instance.map.ContainsKey(ftsClassName))
            {
                return ((ClassMapEntry)instance.map[ftsClassName]).creator;
            }
            else
                return null;
        }

        public static string GetIcon(string ftsClassName)
        {
            if (instance.map.ContainsKey(ftsClassName))
            {
                return ((ClassMapEntry)instance.map[ftsClassName]).icon;
            }
            else
                return null;
        }

        public static string GetCursor(string ftsClassName)
        {
            if (instance.map.ContainsKey(ftsClassName))
            {
                return ((ClassMapEntry)instance.map[ftsClassName]).cursorName;
            }
            else
                return null;
        }

        public static string GetDescription(string ftsClassName)
        {
            if (instance.map.ContainsKey(ftsClassName))
            {
                return ((ClassMapEntry)instance.map[ftsClassName]).description;
            }
            else
                return null;
        }

        public static List<string> ClassNames
        {
            get
            {
                return instance.names;
            }
        }

        private JMaxClassMap()
        {
            map = new Dictionary<string, ClassMapEntry>();
            names = new List<string>();
        }

        public static void Clear()
        {
            instance.map.Clear();
            instance.names.Clear();
        }

        private static JMaxClassMap instance = new JMaxClassMap();
        private Dictionary<string, ClassMapEntry> map;
        private List<string> names;
    }
}