//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;
using System.Reflection;
using System.Globalization;

namespace ircam.jmax
{
    public class JMaxPackageLoader
    {
        public static void Load(string packageName)
        {
            CultureInfo cultureInfo = CultureInfo.CurrentCulture;
            TextInfo textInfo = cultureInfo.TextInfo;

            string fileName = packageName + ".dll";
            string fs = Path.DirectorySeparatorChar.ToString();
            string packagePath = ((string)JMaxLibrary.EnvironmentVariables["jmaxRoot"]) + fs + "packages";
            string dllPath = packagePath + fs + packageName + fs + "cs" + fs + fileName;
            string className = textInfo.ToTitleCase(packageName);

            try
            {
                FileInfo f = new FileInfo(dllPath);

                if (!f.Exists)
                    throw new FileNotFoundException();
            }
            catch (FileNotFoundException e)
            {
                return;
            }
            catch (Exception e)
            {
                throw new JMaxPackageLoadingException(e.GetType().FullName + " " + e.ToString());
            }

            try
            {
                Assembly assembly = Assembly.LoadFrom(dllPath);
                IMaxPackage imaxPackage = (IMaxPackage)assembly.CreateInstance(className);
                imaxPackage.Load();
            }
            catch (Exception e)
            {
                throw new JMaxPackageLoadingException(e.GetType().FullName + " " + e.ToString());
            }
        }
    }
}