//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

using System;
using System.IO;
using System.Collections.Generic;

namespace ircam.jmax
{
    public class RecentFileHistory
    {
        private List<FileInfo> files = new List<FileInfo>();
        internal int maxSize;

        public RecentFileHistory(int maxSize0)
        {
            maxSize = maxSize0;

            Load();
        }

        public void Load()
        {
            FileInfo file = HistoryFileName();
            FileInfo recentFile;

            if (!file.Exists)
                return;

            try
            {
                StreamReader streamReader = new StreamReader(file.FullName);

                string line;

                while ((line = streamReader.ReadLine()) != null)
                {
                    recentFile = new FileInfo(line);
                    if (File.Exists(recentFile.FullName))
                        AddFile(recentFile);
                }
                streamReader.Close();
            }
            catch (IOException e)
            {
                Console.Out.WriteLine("I/O error reading recent file history '" + file.FullName + "':\n" + e.ToString());
            }

        }

        public void Save()
        {
            FileInfo file = HistoryFileName();

            try
            {
                StreamWriter streamWriter = new StreamWriter(file.FullName, false);

                // Save in reverse order
                foreach (FileInfo fileInfo in files)
                {
                    streamWriter.Write(fileInfo.FullName);
                    streamWriter.WriteLine();
                }

                streamWriter.Close();
            }
            catch (IOException e)
            {
                Console.Out.WriteLine("I/O error reading recent file history '" + file.FullName + "':\n" + e.ToString());
            }
        }

        private FileInfo HistoryFileName()
        {
            return new FileInfo((string)ircam.jmax.JMaxLibrary.EnvironmentVariables["USERPROFILE"] + "\\" + ".jmax_history");
        }

        public void AddFile(FileInfo file)
        {
            if (files.Contains(file))
                return;

            files.Insert(0, file);
            if (files.Count > maxSize)
            {
                files.RemoveRange(maxSize, files.Count - maxSize);
            }
        }

        public List<FileInfo> FileList
        {
            get
            {
                return files;
            }
        }
    }
}