//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;
using System.Windows.Forms;

using ircam.jmax;

namespace ircam.jmax.dialogs
{
    /// <summary> 
    /// A File Dialog that provide the concept
    /// of current directory, and a few more things, using the JFileChooser.
    /// Use the *static* methods.
    /// 
    /// </summary>

    public class MaxFileChooser
    {
        private static OpenFileDialog ofd;
        private static SaveFileDialog sfd;

        public const int JMAX_FILE_TYPE = 1;
        public const int PAT_FILE_TYPE = 0;

        private static int saveType;

        internal static void MakeOpenFileChooser()
        {
            ofd = new OpenFileDialog();
            ofd.InitialDirectory = (string)JMaxLibrary.EnvironmentVariables["user.dir"];
        }

        internal static void MakeSaveFileChooser()
        {
            sfd = new SaveFileDialog();
            sfd.InitialDirectory = (string)JMaxLibrary.EnvironmentVariables["user.dir"];
        }

        public static int SaveType
        {
            get
            {
                return saveType;
            }
            set
            {
                saveType = value;

                string currentFile = sfd.FileName;

                string name;
                if (currentFile != null)
                    name = currentFile;
                else
                    name = "untitled.jmax";
                string suffix = "";

                if (saveType == JMAX_FILE_TYPE)
                    suffix = ".jmax";
                else if (saveType == PAT_FILE_TYPE)
                    suffix = ".pat";

                if (name.EndsWith(".jmax") || name.EndsWith(".pat"))
                {
                    int i = name.LastIndexOf('.');

                    string newName = null;

                    try
                    {
                        newName = name.Substring(0, (i) - (0)) + suffix;
                        sfd.FileName = newName;
                    }
                    catch (ArgumentOutOfRangeException exc)
                    {
                    }
                }

                if (SaveType == MaxFileChooser.JMAX_FILE_TYPE)
                    sfd.FilterIndex = 1;
                else
                    sfd.FilterIndex = 2;
            }
        }

        /// <summary>New Loading structure (beginning): global "Open" FileDialog that handle current directory </summary>

        /// <summary>CHoose a file for opening, in the current directory, with a given f ilename filter </summary>

        public static string ChooseFileToOpen(Form form)
        {
            return ChooseFileToOpen(form, "Open");
        }

        public static string ChooseFileToOpen(Form form, string title)
        {
            if (ofd == null)
            {
                MakeOpenFileChooser();
                ofd.Filter = "jMax files (*.jmax)|*.jmax|Patcher files (*.pat)|*.pat|All files (*.*)|*.*";
            }

            ofd.Title = title;
            if (ofd.ShowDialog() == DialogResult.OK)
                return ofd.FileName;
            else
                return null;
        }

        /* CHoose a file to save, having an old File as initial content of the dialog box */

        public static string ChooseFileToSave(Form form, FileInfo oldFile)
        {
            return ChooseFileToSave(form, oldFile, "Save");
        }

        public static string ChooseFileToSave(Form form, FileInfo oldFile, string title)
        {
            if (sfd == null)
            {
                MakeSaveFileChooser();
                sfd.Filter = "jMax files (*.jmax)|*.jmax|Patcher files (*.pat)|*.pat|All files (*.*)|*.*";
            }

            sfd.Title = title;
            if (oldFile != null)
                sfd.FileName = oldFile.FullName;

            if (sfd.ShowDialog() == DialogResult.OK)
                return sfd.FileName;
            else
                return null;
        }

        public static string ChooseFileToSave(Form form, FileInfo oldFile, string title, int type)
        {
            if (sfd == null)
                MakeSaveFileChooser();

            SaveType = type;

            return ChooseFileToSave(form, oldFile, title);
        }
    }
}
