using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace ircam.jmax.dialogs
{
	public partial class SplashDialog: Form
	{
        delegate void DisposeSplashCallback();

        private const int SPLASH_SHOW_DURATION = 4000;
        
        private TimerState timerState;

        class TimerState
        {
            public int counter = 0;
            public System.Threading.Timer timer;
        }

		public SplashDialog()
		{
			InitializeComponent();

            this.versionLabel.Text = JMaxVersion.Version;
            InitializeThreadTimer();
		}

        private void InitializeThreadTimer()
        {
            timerState = new TimerState();
            TimerCallback timerDelegate = new TimerCallback(StartThread);

            timerState.timer = new System.Threading.Timer(timerDelegate, timerState, 0, SPLASH_SHOW_DURATION);
        }

        private void StartThread(object state)
        {
            timerState = (TimerState)state;
            timerState.counter++;

            if (timerState.counter == 1)
                return;
            else
                DisposeSplash();
        }

        private void DisposeSplash()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new DisposeSplashCallback(DisposeSplash));
            }
            else
            {
                timerState.timer.Dispose();
                timerState.timer = null;
                this.Close();
                this.Dispose();
            }
        }

        private void SplashDialog_Click(object sender, EventArgs e)
        {
            DisposeSplash();
        }

        private void SplashDialog_KeyDown(object sender, KeyEventArgs e)
        {
            DisposeSplash();
        }
	}
}