//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.jmax;

namespace ircam.jmax.editors.patcher
{
    public class ScaleTransform
    {
        private float scaleX;
        private float invScaleX;
        private float scaleY;
        private float invScaleY;

        private static ScaleTransform instance;

        public static ScaleTransform Instance
        {
            get
            {
                if (instance == null)
                    instance = new ScaleTransform();
                return instance;
            }
        }

        public ScaleTransform()
        {
            fontName = defaultFontName;
            baseSize = defaultBaseSize;

            initFontMetrics();

            scaleX = (float)1.0;
            invScaleX = 1 / scaleX;
            scaleY = (float)1.0;
            invScaleY = 1 / scaleY;
        }

        public void recomputeScaleFactors(string fName, int bSize)
        {
            fontName = fName;
            baseSize = bSize;

            initFontMetrics();

            scaleX = computeScaleX();
            invScaleX = 1 / scaleX;
            scaleY = computeScaleY();
            invScaleY = 1 / scaleY;
        }

        public void fontBaseChanged(int bSize)
        {
            recomputeScaleFactors(fontName, bSize);
//UNDONE: Interface 'javax.swing.ListModel' was not converted.
//          ListModel windows = MaxWindowManager.WindowManager.WindowList;
//UNDONE: Method 'javax.swing.ListModel.getSize' was not converted.
//          for (int i = 0; i < windows.getSize(); i++)
//          {
//UNDONE: Method 'javax.swing.ListModel.getElementAt' was not converted.
//              ((ErmesSketchWindow) windows.getElementAt(i)).fontBaseChanged(bSize);
//          }
        }

        public int ScaleX(float x)
        {
            return (int)System.Math.Round((double)(x * scaleX));
        }

        public float InvScaleX(int x)
        {
            return x * invScaleX;
        }

        public int ScaleY(float y)
        {
            return (int)System.Math.Round((double)(y * scaleY));
        }

        public float InvScaleY(int y)
        {
            return y * invScaleY;
        }

        private float computeScaleX()
        {
            string str;
            StringDescription d;
            float temp;
            float[] maxs = new float[] { (float)0.0, (float)0.0, (float)0.0, (float)0.0, (float)0.0, (float)0.0 };
            //find max for every font size
            for (int i = 0; i < xReferences.Length; i++)
            {
                d = xReferences[i];
                for (int j = 0; j < numSizes; j++)
                {
//UNDONE: Method 'java.awt.FontMetrics.stringWidth' was not converted.
//Convert your data to a String object, create a Graphics object and call the MeasureString method to obtain a size object. 
//                  temp = (float) standardFontMetrics[j].stringWidth(d.ToString()) / (float) d.width(j);
//                  if (temp > maxs[j])
//                      maxs[j] = temp;
                }
            }
            //medium of maxs[i] without maximum value
            float medium = (float)0.0;
            float max = (float)0.0;
            int div = 0;
            for (int i = 0; i < numSizes; i++)
                if (maxs[i] > max)
                    max = maxs[i];
            for (int i = 0; i < numSizes; i++)
                if (maxs[i] < max)
                {
                    medium += maxs[i];
                    div++;
                }
            medium = medium / div;
            return medium;
        }

        private float computeScaleY()
        {
            float temp, medium = (float)0.0;
            float max = (float)0.0;
            for (int j = 0; j < numSizes; j++)
            {
//HACK: The equivalent in .NET for method 'java.awt.FontMetrics.getHeight' may return a different value.
//or FontFamily.GetEmHeight ?
                temp = (float)((int)standardFontMetrics[j].Height / (float)yReferences[j]);
                if (temp > max)
                    max = temp;
                medium += temp;
            }
            medium = (medium - max) / (numSizes - 1);
            //return max;
            return medium;
        }

        internal void initFontMetrics()
        {
            int start = BaseSizeIndex;
            for (int i = 0; i < numSizes; i++)
            {
//UNDONE: Method 'java.awt.Toolkit.getFontMetrics' was not converted.
//UNDONE: Method 'java.awt.Toolkit.getDefaultToolkit' was not converted.
//              standardFontMetrics[i] = Toolkit.getDefaultToolkit().getFontMetrics(new System.Drawing.Font(fontName, standardSizes[start + i], (System.Drawing.FontStyle) System.Drawing.FontStyle.Regular));
            }
        }

        internal int BaseSizeIndex
        {
            get
            {
                for (int i = 0; i < 11; i++)
                    if (standardSizes[i] == baseSize)
                        return i;
                return -1;
            }
        }

        public StringDescription[] xReferences = new StringDescription[] 
        {
            new StringDescription("a", 4, 5, 7, 8, 9, 13),
            new StringDescription("b", 5, 6, 7, 8, 11, 14),
            new StringDescription("c", 4, 5, 7, 8, 10, 12),
            new StringDescription("d", 5, 6, 7, 8, 11, 14),
            new StringDescription("e", 4, 5, 7, 8, 10, 13),
            //new StringDescription("f", 3, 4, 3, 3, 6, 8),
            new StringDescription("g", 5, 6, 7, 8, 11, 14),
            new StringDescription("h", 5, 6, 7, 8, 10, 13),
            new StringDescription("i", 2, 2, 3, 3, 4, 6),
            new StringDescription("j", 2, 2, 3, 3, 4, 6),
            new StringDescription("k", 4, 5, 6, 7, 9, 12),
            new StringDescription("l", 2, 2, 3, 3, 4, 6),
            new StringDescription("m", 6, 8, 9, 11, 14, 20),
            new StringDescription("n", 5, 6, 7, 8, 10, 14),
            new StringDescription("o", 5, 6, 7, 8, 11, 13),
            new StringDescription("p", 5, 6, 7, 8, 11, 14),
            new StringDescription("q", 5, 6, 7, 8, 11, 14),
            new StringDescription("r", 3, 4, 4, 5, 6, 9),
            new StringDescription("s", 4, 5, 6, 8, 9, 12),
            //new StringDescription("t", 3, 4, 3, 4, 6, 8),
            new StringDescription("u", 4, 5, 7, 8, 10, 14),
            new StringDescription("v", 5, 6, 7, 8, 10, 13),
            new StringDescription("x", 5, 6, 6, 7, 10, 12),
            new StringDescription("y", 4, 5, 7, 7, 10, 13),
            new StringDescription("w", 6, 8, 9, 10, 14, 18),
            new StringDescription("z", 4, 5, 6, 7, 9, 12),
            new StringDescription("A", 6, 7, 9, 11, 12, 17),
            new StringDescription("B", 6, 7, 8, 9, 13, 17),
            new StringDescription("C", 6, 8, 9, 10, 14, 18),
            new StringDescription("D", 6, 8, 9, 10, 13, 18),
            new StringDescription("E", 6, 7, 8, 9, 11, 16),
            new StringDescription("F", 5, 6, 8, 9, 11, 14),
            new StringDescription("G", 6, 8, 9, 11, 14, 19),
            new StringDescription("H", 6, 8, 9, 10, 13, 18),
            new StringDescription("I", 2, 3, 3, 5, 6, 8),
            new StringDescription("J", 4, 5, 7, 8, 10, 13),
            new StringDescription("K", 6, 7, 8, 10, 13, 18),
            new StringDescription("L", 5, 6, 7, 8, 10, 14),
            new StringDescription("M", 7, 9, 11, 13, 16, 21),
            new StringDescription("N", 6, 8, 9, 10, 13, 18),
            new StringDescription("O", 6, 8, 10, 11, 15, 18),
            new StringDescription("P", 6, 7, 8, 9, 12, 16),
            new StringDescription("Q", 6, 8, 10, 11, 15, 18),
            new StringDescription("R", 6, 7, 8, 9, 12, 17),
            new StringDescription("S", 6, 7, 8, 9, 13, 16),
            new StringDescription("T", 4, 5, 7, 9, 12, 16),
            new StringDescription("U", 6, 8, 8, 10, 13, 18),
            new StringDescription("V", 6, 7, 9, 11, 14, 17),
            new StringDescription("X", 6, 7, 9, 10, 13, 17),
            new StringDescription("Y", 6, 7, 9, 9, 14, 16),
            new StringDescription("W", 7, 9, 11, 15, 18, 22),
            new StringDescription("Z", 6, 7, 9, 9, 12, 15),
            new StringDescription("0", 5, 6, 7, 8, 10, 13),
            new StringDescription("1", 5, 6, 7, 8, 10, 13),
            new StringDescription("2", 5, 6, 7, 8, 10, 13),
            new StringDescription("3", 5, 6, 7, 8, 10, 13),
            new StringDescription("4", 5, 6, 7, 8, 10, 13),
            new StringDescription("5", 5, 6, 7, 8, 10, 13),
            new StringDescription("6", 5, 6, 7, 8, 10, 13),
            new StringDescription("7", 5, 6, 7, 8, 10, 13),
            new StringDescription("8", 5, 6, 7, 8, 10, 13),
            new StringDescription("9", 5, 6, 7, 8, 10, 13),
            new StringDescription("+", 5, 6, 7, 9, 10, 14),
            new StringDescription("-", 5, 6, 7, 8, 10, 13),
            new StringDescription("*", 3, 4, 5, 7, 7, 10),
            new StringDescription("$", 5, 6, 7, 8, 10, 13),
            new StringDescription("#", 5, 6, 7, 8, 10, 14), 
            new StringDescription("~", 6, 7, 7, 8, 10, 14), 
            new StringDescription("<", 5, 6, 7, 8, 10, 15),
            new StringDescription(">", 5, 6, 7, 8, 10, 15),
            new StringDescription("%", 7, 9, 11, 12, 16, 22),
            new StringDescription("(", 3, 4, 4, 5, 6, 8),
            new StringDescription(")", 3, 4, 4, 5, 6, 8), 
            new StringDescription(".", 2, 3, 3, 3, 5, 6),
            new StringDescription(",", 2, 3, 4, 3, 5, 6),
            new StringDescription(":", 2, 3, 3, 3, 5, 6),
            new StringDescription(";", 2, 3, 3, 4, 5, 6),
            new StringDescription(" ", 2, 3, 4, 4, 5, 6)
        };

        public int[] yReferences = new int[] { 11, 13, 15, 17, 22, 28 };

        public const string defaultFontName = "SansSerif";
        public const int defaultBaseSize = 8;

        public string fontName;
        public int baseSize;

        public static int numSizes = 6;
        public int[] standardSizes = new int[] { 8, 10, 12, 14, 18, 24, 36, 48, 60, 72, 84 };

        public System.Drawing.Font[] standardFontMetrics = new System.Drawing.Font[numSizes];

        public class StringDescription
        {
            string str;
            public int[] widths = new int[6];

            public StringDescription(string str, int s8, int s10, int s12, int s14, int s18, int s24)
            {
                this.str = str;
                widths[0] = s8;
                widths[1] = s10;
                widths[2] = s12;
                widths[3] = s14;
                widths[4] = s18;
                widths[5] = s24;
            }

            public int width(int index)
            {
                if (index < 6)
                    return widths[index];
                else
                    return 0;
            }
        }
    }
}