//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.jmax;
using ircam.jmax.fts;
using ircam.jmax.dialogs;
using ircam.jmax.toolkit;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher
{
    public class ToolBar
    {
        internal ErmesSketchPad sketch;

        private bool staySelected = false;
        internal bool pressed = false;

//UNDONE: Class 'javax.swing.JPanel' was not converted.
//        internal JPanel toolBar;
//UNDONE: Class 'java.awt.CardLayout' was not converted.
//        internal CardLayout cardLayout;
//UNDONE: Class 'javax.swing.JPanel' was not converted.
//        internal JPanel cards;
//UNDONE: Class 'javax.swing.JToggleButton' was not converted.
//        internal JToggleButton lockEditButton;
//UNDONE: Class 'javax.swing.JButton' was not converted.
//        internal JButton upButton;
//UNDONE: Class 'javax.swing.JButton' was not converted.
//        internal JButton toSaveButton;
//UNDONE: Class 'javax.swing.ButtonGroup' was not converted.
//        internal ButtonGroup bGroup;
//UNDONE: Class 'javax.swing.JToggleButton' was not converted.
//
//        ButtonGroup bGroup;
//        internal JToggleButton noneButton;
        internal ToolButton selectedButton = null;
        internal int numButtons = 0;
        internal bool dirty = false;

        private class WaitingActionListener
        {
            public WaitingActionListener(ToolBar toolBar)
            {
                this.toolBar = toolBar;
            }

            public void actionPerformed(System.EventArgs e)
            {
                toolBar.sketch.waiting();
                ((FtsPatcherObject)toolBar.sketch.FtsPatcher.Parent).RequestOpenEditor();
                toolBar.sketch.FtsPatcher.RequestStopWaiting();
            }

            private ToolBar toolBar;
        }

        private class SaveActionListener
        {
            public SaveActionListener(ToolBar toolBar)
            {
                this.toolBar = toolBar;
            }

            public void actionPerformed(System.EventArgs e)
            {
//UNDONE: Method 'javax.swing.tree.DefaultTreeCellEditor.EditorContainer' was not converted.
//                PatcherSaveManager.save(toolBar.sketch.EditorContainer);
            }

            private ToolBar toolBar;
        }

        private class LockedItemListener
        {
            public LockedItemListener(ToolBar toolBar)
            {
                this.toolBar = toolBar;
            }

            public void itemStateChanged(System.EventArgs e)
            {
//UNDONE: Method 'java.awt.event.ItemEvent.getStateChange' was not converted. 
//UNDONE: Field 'java.awt.event.ItemEvent.SELECTED' was not converted.
//                if (e.getStateChange() == ItemEvent.SELECTED)
//                    toolBar.sketch.setLocked(false);
//                else
//                    toolBar.sketch.setLocked(true);
            }

            private ToolBar toolBar;
        }

        public ToolBar(ErmesSketchPad theSketchPad)
        {
            sketch = theSketchPad;
            
//UNDONE: Method 'javax.swing.JComponent.setDoubleBuffered' was not converted.
//            setDoubleBuffered(false);
//            
//UNDONE: Method 'java.awt.Container.setLayout' was not converted.
//UNDONE: Constructor 'java.awt.BorderLayout.BorderLayout' was not converted.
//            setLayout(new BorderLayout());
//            
//UNDONE: Constructor 'javax.swing.JToggleButton.JToggleButton' was not converted.
//            noneButton = new JToggleButton();
//UNDONE: Constructor 'javax.swing.ButtonGroup.ButtonGroup' was not converted.
//            bGroup = new ButtonGroup();
//UNDONE: Method 'javax.swing.ButtonGroup.add' was not converted.
//            bGroup.add(noneButton);
//            
//UNDONE: Constructor 'javax.swing.JToggleButton.JToggleButton' was not converted.
//            lockEditButton = new JToggleButton(JMaxIcons.lockMode);
//UNDONE: Method 'javax.swing.JComponent.setDoubleBuffered' was not converted.
//            lockEditButton.setDoubleBuffered(false);
//UNDONE: Method 'javax.swing.AbstractButton.setMargin' was not converted.
//            lockEditButton.setMargin(new System.Drawing.Rectangle(0, 0, 0, 0));
//UNDONE: Method 'javax.swing.AbstractButton.setSelectedIcon' was not converted.
//            lockEditButton.setSelectedIcon(JMaxIcons.editMode);
//UNDONE: Method 'javax.swing.AbstractButton.setFocusPainted' was not converted.
//            lockEditButton.setFocusPainted(false);
//            lockEditButton.addItemListener(new WaitingActionListener(this));
//            
//UNDONE: Method 'java.awt.Container.add' was converted to 'System.Drawing.ContainerControl.Controls.Add' which has a different behavior.
//            Controls.Add(lockEditButton);
            numButtons++;
            
            //widgets panel
//UNDONE: Class 'javax.swing.JPanel' was not converted.
//UNDONE: Constructor 'javax.swing.JPanel.JPanel' was not converted.
//            JPanel widgets = new JPanel();
//UNDONE: Method 'javax.swing.JComponent.setBorder' was not converted.
//UNDONE: Constructor 'javax.swing.border.EmptyBorder.EmptyBorder' was not converted.
//            widgets.setBorder(new EmptyBorder(0, 0, 0, 0));
//UNDONE: Method 'java.awt.Container.setLayout' was not converted.
//UNDONE: Constructor 'javax.swing.BoxLayout.BoxLayout' was not converted.
//UNDONE: Field 'javax.swing.BoxLayout.X_AXIS' was not converted.
//            widgets.setLayout(new BoxLayout(widgets, BoxLayout.X_AXIS));
            
            //to save button
//UNDONE: Constructor 'javax.swing.JButton.JButton' was not converted.
//            toSaveButton = new JButton(JMaxIcons.toSave);
//UNDONE: Method 'javax.swing.JComponent.setDoubleBuffered' was not converted.
//            toSaveButton.setDoubleBuffered(false);
//UNDONE: Method 'javax.swing.AbstractButton.setMargin' was not converted.
//            toSaveButton.setMargin(new System.Drawing.Rectangle(0, 0, 0, 0));
//            toSaveButton.addActionListener(new SaveActionListener(this));
//UNDONE: Method 'javax.swing.JComponent.setToolTipText' was not converted.
//            toSaveButton.setToolTipText("save file");
            this.dirty = sketch.FtsPatcher.IsDirty;
//UNDONE: Method 'javax.swing.AbstractButton.setEnabled' was not converted.
//            toSaveButton.setEnabled(dirty);
//UNDONE: Method 'javax.swing.JComponent.setVisible' was not converted.
//            toSaveButton.setVisible(dirty);
//            
//UNDONE: Method 'java.awt.Container.add' was converted to 'System.Windows.Forms.ContainerControl.Controls.Add' which has a different behavior.
//            widgets.Controls.Add(toSaveButton);
            /////////////////////
            
            if ((sketch.FtsPatcher.Parent!= null) && (!sketch.isARootPatcher()))
            {
//UNDONE: Constructor 'javax.swing.JButton.JButton' was not converted.
//                upButton = new JButton(JMaxIcons.up);
//UNDONE: Method 'javax.swing.JComponent.setDoubleBuffered' was not converted.
//                upButton.setDoubleBuffered(false);
//UNDONE: Method 'javax.swing.AbstractButton.setMargin' was not converted.
//                upButton.setMargin(new System.Drawing.Rectangle(0, 0, 0, 0));
//UNDONE: Method 'javax.swing.JComponent.setToolTipText' was not converted.
//                upButton.setToolTipText("show parent patcher");
//                upButton.addActionListener(new LockedItemListener(this));
//                
//UNDONE: Method 'java.awt.Container.add' was converted to 'System.Windows.Forms.ContainerControl.Controls.Add' which has a different behavior.
//                widgets.Controls.Add(upButton);
            }
//UNDONE: Method 'java.awt.Container.add' was converted to 'System.Drawing.ContainerControl.Controls.Add' which has a different behavior.
//            Controls.Add(widgets);
//            
//UNDONE: Constructor 'javax.swing.JPanel.JPanel' was not converted.
//            cards = new JPanel();
//UNDONE: Method 'javax.swing.JComponent.setBorder' was not converted.
//UNDONE: Constructor 'javax.swing.border.EmptyBorder.EmptyBorder' was not converted.
//            cards.setBorder(new EmptyBorder(0, 0, 0, 0));
//            
//UNDONE: Constructor 'java.awt.CardLayout.CardLayout' was not converted.
//            cardLayout = new CardLayout();
//UNDONE: Method 'java.awt.Container.setLayout' was not converted.
//            cards.setLayout(cardLayout);
//            
//UNDONE: Method 'java.awt.Container.add' was converted to 'System.Drawing.ContainerControl.Controls.Add' which has a different behavior.
//            Controls.Add(cards);
//            
//UNDONE: Class 'javax.swing.JPanel' was not converted.
//UNDONE: Constructor 'javax.swing.JPanel.JPanel' was not converted.
//            JPanel empty = new JPanel();
//            
//            cards.Controls.Add(empty);
//UNDONE: Method 'javax.swing.JComponent.setBorder' was not converted.
//UNDONE: Constructor 'javax.swing.border.EmptyBorder.EmptyBorder' was not converted.
//            cards.setBorder(new EmptyBorder(0, 0, 0, 0));
//            
//UNDONE: Constructor 'javax.swing.JPanel.JPanel' was not converted.
//            toolBar = new JPanel();
//UNDONE: Method 'javax.swing.JComponent.setBorder' was not converted.
//UNDONE: Constructor 'javax.swing.border.EmptyBorder.EmptyBorder' was not converted.
//            toolBar.setBorder(new EmptyBorder(0, 0, 0, 0));
//UNDONE: Method 'java.awt.Container.setLayout' was not converted.
//UNDONE: Constructor 'javax.swing.BoxLayout.BoxLayout' was not converted.
//UNDONE: Field 'javax.swing.BoxLayout.X_AXIS' was not converted.
//            toolBar.setLayout(new BoxLayout(toolBar, BoxLayout.X_AXIS));
//            insertButtons();
//            
//            cards.Controls.Add(toolBar);
//            
//            //UNDONE: Constructor 'javax.swing.ButtonGroup.ButtonGroup' was not converted.
//            bGroup = new ButtonGroup();
//            
//UNDONE: Extra logic should be included into componentHidden to know if the Component is hidden.
//            VisibleChanged += new System.EventHandler(this.componentHidden);
//            Move += new System.EventHandler(this.componentMoved);
//            Resize += new System.EventHandler(this.componentResized);
//UNDONE: Extra logic should be included into componentShown to know if the Component is visible.
//            VisibleChanged += new System.EventHandler(this.componentShown);
        }

        public ErmesSketchPad SketchPad
        {
            get
            {
                return sketch;
            }
        }

        internal void buttonSelected(ToolButton button)
        {
            if (selectedButton != null)
                selectedButton.reset();
            selectedButton = button;
            sketch.setAddModeInteraction(selectedButton.Description, selectedButton.Message, true);
        }

        public void reset()
        {
            if (selectedButton != null)
            {
                selectedButton.reset();
                selectedButton = null;
            }
//UNDONE: Method 'javax.swing.AbstractButton.setSelected' was not converted.
//            noneButton.setSelected(true);
        }

        protected internal bool isLocked
        {
            set
            {
                if (value)
                {
//UNDONE: Method 'javax.swing.AbstractButton.isSelected' was not converted.
//                    if (lockEditButton.isSelected())
//                    {
//UNDONE: Method 'javax.swing.AbstractButton.setSelected' was not converted.
//                        lockEditButton.setSelected(false);
//                    }
                }
                else
                {
//UNDONE: Method 'javax.swing.AbstractButton.isSelected' was not converted.
//                    if (!lockEditButton.isSelected())
//                    {
//UNDONE: Method 'javax.swing.AbstractButton.setSelected' was not converted.
//                        lockEditButton.setSelected(true);
//                    }
                }
                
//UNDONE: Method 'java.awt.CardLayout.show' was not converted.
//                cardLayout.show( cards, locked ? "lock" : "edit");
            }

        }

        private void addButton(string className)
        {
//UNDONE: Class 'javax.swing.JToggleButton' was not converted.
//            JToggleButton button = new ToolButton(this, className);
//UNDONE: Method 'java.awt.Container.add' was converted to 'System.Windows.Forms.ContainerControl.Controls.Add' which has a different behavior.
//            toolBar.Controls.Add(button);
//            if (!AddPopUp.initDone_Renamed_Field)
//                AddPopUp.addAbbreviation(className, MaxClassMap.getIcon(className), true);
//            
//UNDONE: Method 'javax.swing.ButtonGroup.add' was not converted.
//            bGroup.add(button);
//            numButtons++;
        }

        private void insertButtons()
        {
            JMaxClassMap.ClassNames.ForEach(
                delegate(string s)
                {
                    addButton(s);
                });

//UNDONE: Class AddPopUp Not Yet Implemented.            
//            AddPopUp.initDone();
        }

        public bool IsDirty
        {
            set
            {
                if (this.dirty != value)
                {
//UNDONE: Method 'javax.swing.AbstractButton.setEnabled' was not converted.
//                    toSaveButton.setEnabled(value);
//UNDONE: Method 'javax.swing.JComponent.setVisible' was not converted.
//                    toSaveButton.setVisible(value);
//UNDONE: Method 'java.awt.Component.repaint' was not converted.                    
                    this.dirty = value;
                }
            }
        }
        
        // Component Listener Interface
        internal System.Collections.ArrayList removedButtons = new System.Collections.ArrayList();
        internal const int BUTTON_WIDTH = 21;
//        internal MoreObjectsButton moreButton = null;

        public void componentResized(System.EventArgs e)
        {
//UNDONE: 'java.awt.Component.getSize()' was not converted.
//            int toolbarwidth = getSize().Width - 2 * BUTTON_WIDTH - 10;
//            int visibleButtons = ((toolbarwidth / BUTTON_WIDTH) > numButtons) ? numButtons:toolbarwidth / BUTTON_WIDTH;
//            int numPopButtons = numButtons - visibleButtons;
//            
//            if (numPopButtons == 1)
//            {
//                numPopButtons = 0;
//                visibleButtons++;
//            }
//            if (numPopButtons == removedButtons.Count)
//                return ;
//            
//            if (numPopButtons > removedButtons.Count)
//            {
//                ToolButton button;
//                int where = numButtons - removedButtons.Count;
//                int toRemove = numPopButtons - removedButtons.Count;
//                
//                for (int i = 0; i < toRemove; i++)
//                {
//                    if (where - 2 >= 0)
//                    {
//UNDONE: Class 'javax.swing.JPanel' was not converted.
//                        button = (ToolButton) (toolBar.Controls[where - 2]);
//                        toolBar.Controls.RemoveAt(where - 2);
//                        removedButtons.Add(button);
//                        where--;
//                    }
//                }
//                if (moreButton != null)
//                    moreButton.update(removedButtons.GetEnumerator(), removedButtons.Count);
//                else
//                {
//                    moreButton = new MoreObjectsButton(removedButtons.GetEnumerator());
//UNDONE: Method 'java.awt.Container.add' was converted to 'System.Windows.Forms.ContainerControl.Controls.Add' which has a different behavior.
//                    toolBar.Controls.Add(moreButton);
//                }
//            }
//            else
//            {
//                ToolButton button;
//                int where = removedButtons.Count - numPopButtons;
//                toolBar.remove(moreButton);
//                
//                for (int i = 0; i < where; i++)
//                {
//UNDONE: Class 'javax.swing.JPanel' was not converted.
//                    button = (ToolButton) (SupportClass.VectorLastElement(removedButtons));
//                    toolBar.Controls.Add(button);
//                    removedButtons.Remove(button);
//                }
//                if (removedButtons.Count > 0)
//                {
//                    toolBar.Controls.Add(moreButton);
//                    moreButton.update(removedButtons.GetEnumerator(), removedButtons.Count);
//                }
//                else
//                    moreButton = null;
//            }
//UNDONE: Class 'javax.swing.JPanel' was not converted.
//            toolBar.Validate();
        }

        public void componentMoved(System.EventArgs e) { }
        public void componentShown(System.EventArgs e) { }
        public void componentHidden(System.EventArgs e) { }
    }
}