// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.jmax;
using ircam.jmax.toolkit;

namespace ircam.jmax.editors.patcher
{
    class ToolButton
    {
        private string description;
        private string message;
        private ToolBar toolBar;
        private bool state = false;
        private System.Windows.Forms.Cursor cursor;

//UNDONE: Interface 'java.awt.event.MouseListener' was not converted.        
//        internal class ToolButtonMouseAdapter
//        {
//            public void  mousePressed(System.Windows.Forms.MouseEventArgs e)
//            {
//UNDONE: The method 'java.util.EventObject.getSource' needs to be in a event handling method in order to be properly converted.
//                ToolButton button = (ToolButton) event_sender;
//UNDONE: Method 'javax.swing.AbstractButton.isSelected' was not converted.
//                if (!button.isSelected())
//                {
//                    button.state = true;
//UNDONE: Method 'javax.swing.AbstractButton.setSelected' was not converted.
//                    button.setSelected(true);
//                    button.toolBar.buttonSelected(button);
//                    button.Cursor = button.ButtonCursor;
//                    button.toolBar.SketchPad.Cursor = button.ButtonCursor;
//                }
//            }
//        }

        //internal static MouseListener mListener = new ToolButtonMouseAdapter();
        
        internal ToolButton(ToolBar toolBar, string name)
        {
            //this.cursor = MaxClassMap.Cursor(name);
            if (!name.Equals("standard"))
                this.description = name;
            else
                this.description = "";
            
            this.message = "";
            this.toolBar = toolBar;
            
//UNDONE: Method 'javax.swing.JComponent.setDoubleBuffered' was not converted.
//            setDoubleBuffered(false);
//UNDONE: Method 'javax.swing.AbstractButton.setMargin' was not converted.
//            setMargin(new System.Drawing.Rectangle(0, 0, 0, 0));
            
            string toolTip = JMaxClassMap.GetDescription(name);
            if ((object) toolTip == null)
            {
//UNDONE: Method 'javax.swing.JComponent.setToolTipText' was not converted.
//                setToolTipText(name + " object");
            }
            else
            {
//UNDONE: Method 'javax.swing.JComponent.setToolTipText' was not converted.
//                setToolTipText(toolTip);
            }
            
            //Click += new System.EventHandler(ToolButton.mListener.mouseClicked);
            //MouseEnter += new System.EventHandler(ToolButton.mListener.mouseEntered);
            //MouseLeave += new System.EventHandler(ToolButton.mListener.mouseExited);
            //MouseDown += new System.Windows.Forms.MouseEventHandler(ToolButton.mListener.mousePressed);
            //MouseUp += new System.Windows.Forms.MouseEventHandler(ToolButton.mListener.mouseReleased);
        }
        
        internal void reset()
        {
            state = false;
//UPGRADE_ISSUE: Member 'java.awt.Cursor.getDefaultCursor' was converted to 'System.Windows.Forms.Cursors.Default' which cannot be assigned to an int.
//            Cursor = System.Windows.Forms.Cursors.Default;
//UPGRADE_ISSUE: Member 'java.awt.Cursor.getDefaultCursor' was converted to 'System.Windows.Forms.Cursors.Default' which cannot be assigned to an int.
//            toolBar.SketchPad.Cursor = System.Windows.Forms.Cursors.Default;
        }

        internal string Description
        {
            get
            {
                return description;
            }
        }

        internal string Message
        {
            get
            {
                return message;
            }
        }

        internal System.Windows.Forms.Cursor ButtonCursor
        {
            get
            {
                return cursor;
            }
        }
    }
}