//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.fts;
using ircam.jmax.dialogs;
using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;
using ircam.jmax.editors.patcher.interactions;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>The interaction handling Moves cursor changes; 
    /// Note that each interaction should set its initial cursor.
    /// </summary>

    internal class FollowInteraction : Interaction
    {
        internal override void configureInputFilter(InteractionEngine filter)
        {
            filter.isFollowingMoves = true;
        }

        internal override void gotSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            if (Squeack.isMove(squeack))
            {
                editor.resetHighlightedInlet();
                editor.resetHighlightedOutlet();

                if (Squeack.onBackground(squeack))
                {
                    editor.resetMessage();
                    //                    editor.Cursor = System.Windows.Forms.Cursors.Default;
                }
                else if (Squeack.onObject(squeack))
                {
                    //                    editor.Cursor = System.Windows.Forms.Cursors.Default;
                    ((GraphicObject)area.Target).assistOnObject();
                }
                else if (Squeack.onConnection(squeack))
                {
                    editor.resetMessage();
                    //                    editor.Cursor = System.Windows.Forms.Cursors.Default;
                }
                else if (Squeack.onHResizeHandle(squeack))
                {
                    editor.resetMessage();
                    //                    editor.Cursor = System.Windows.Forms.Cursors.SizeWE;
                }
                else if (Squeack.onVResizeHandle(squeack))
                {
                    editor.resetMessage();
                    //                    editor.Cursor = System.Windows.Forms.Cursors.SizeNS;
                }
                else if (Squeack.onInlet(squeack))
                {
                    if (!editor.isHighlightedInlet((GraphicObject)area.Target, area.Number))
                    {
                        editor.setHighlightedInlet((GraphicObject)area.Target, area.Number);
                        //                        editor.Cursor = System.Windows.Forms.Cursors.Default;
                    }

                    ((GraphicObject)area.Target).assistOnInlet(area.Number);
                }
                else if (Squeack.onOutlet(squeack))
                {
                    if (!editor.isHighlightedOutlet((GraphicObject)area.Target, area.Number))
                    {
                        editor.setHighlightedOutlet((GraphicObject)area.Target, area.Number);
                        //                        editor.Cursor = System.Windows.Forms.Cursors.Default;
                    }

                    ((GraphicObject)area.Target).assistOnOutlet(area.Number);
                }
                else if (Squeack.onText(squeack))
                {
                    ((GraphicObject)area.Target).assistOnObject();
                    //                    editor.Cursor = System.Windows.Forms.Cursors.Default;
                }
            }

            editor.endInteraction();
        }
    }
}