//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>The interaction handling moving objects in edit mode; 
    /// As a special case, can open the editfield on the object
    /// content if the move didn't worked out.
    /// </summary>

    internal class MoveEditInteraction : Interaction
    {
        internal GraphicObject obj;
        internal bool dragged;

        internal override void configureInputFilter(InteractionEngine filter)
        {
            filter.isFollowingMoves = true;
            filter.isAutoScrolling = true;
        }

        internal override void gotSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            if (Squeack.isDown(squeack) && Squeack.onText(squeack))
            {
                obj = (GraphicObject)area.Target;
                //**********************
                // "to front" feature removed in order to make faster mouseclick objects selection 
                //**********************
                //editor.getDisplayList().objectToFront(object);
                //object.redraw();
                //object.redrawConnections();
                dragged = false;
            }
            else if (Squeack.isDrag(squeack))
            {
                if (!dragged)
                {
                    //                    editor.Cursor = System.Windows.Forms.Cursors.Default;

                    dragged = true;

                    if (!obj.isSelected)
                    {
                        if (!ErmesSelection.patcherSelection.isEmpty)
                        {
                            ErmesSelection.patcherSelection.redraw();
                            ErmesSelection.patcherSelection.DeselectAll();
                        }

                        ErmesSelection.patcherSelection.select(obj);
                        obj.Redraw();
                    }

                    editor.setUndo("Move", false, false);
                }

                ErmesSelection.patcherSelection.moveAllBy(mouse.X - oldMouse.X, mouse.Y - oldMouse.Y);
                editor.fixSize();
            }
            else if (Squeack.isUp(squeack))
            {
                if (!dragged)
                {
                    if (!ErmesSelection.patcherSelection.isEmpty)
                    {
                        ErmesSelection.patcherSelection.redraw();
                        ErmesSelection.patcherSelection.DeselectAll();
                    }

                    obj.Edit(mouse);
                }

                editor.endInteraction();
            }
        }
    }
}