//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>A squeack is a mouse action (squeack !); this class
    /// contains all the constants for coding mouse actions
    /// in the patcher editor.
    /// </summary>

    public class Squeack
    {
        // The following flags are combined to create mouse events integers

        // mouse action; 4 bit reserved

        public const int MOVE = 0x1;
        public const int DRAG = 0x2;
        public const int DOWN = 0x3;
        public const int UP = 0x4;
        public const int DOUBLE_CLICK = 0x5;
        public const int POP_UP = 0x6;

        public const int MOUSE_MASK = 0xf;


        static public bool isMove(int squeack)
        {
            return (squeack & MOUSE_MASK) == MOVE;
        }

        static public bool isDrag(int squeack)
        {
            return (squeack & MOUSE_MASK) == DRAG;
        }

        static public bool isDown(int squeack)
        {
            return (squeack & MOUSE_MASK) == DOWN;
        }

        static public bool isUp(int squeack)
        {
            return (squeack & MOUSE_MASK) == UP;
        }

        static public bool isDoubleClick(int squeack)
        {
            return (squeack & MOUSE_MASK) == DOUBLE_CLICK;
        }

        static public bool isPopUp(int squeack)
        {
            return (squeack & MOUSE_MASK) == POP_UP;
        }

        // Modifiers, 4 bit reserved, multiple value possible, but not currently generated

        public const int SHIFT = 0x10;
        //public const int CTRL        = 0x20;
        public const int SHORTCUT = 0x20;
        public const int SHIFT_UP = 0x30;
        public const int ALT = 0x40;
        public const int ESCAPE = 0x50;
        public const int DELETE = 0x60;
        public const int MIDDLE_BUTTON = 0x70;

        public const int MODIFICATION_MASK = 0xf0;

        static public bool isShift(int squeack)
        {
            return (squeack & SHIFT) != 0;
        }

        /*static public bool isCtrl(int squeack)
        {
            return (squeack & CTRL) != 0;
        }*/

        static public bool isShortcut(int squeack)
        {
            return (squeack & SHORTCUT) != 0;
        }

        static public bool isAlt(int squeack)
        {
            return (squeack & ALT) != 0;
        }

        static public bool isMiddleButton(int squeack)
        {
            return (squeack & MIDDLE_BUTTON) != 0;
        }
        // Location, 8 bit reserved

        public const int UNKNOWN = 0x0000;
        public const int BACKGROUND = 0x0100;
        public const int OBJECT = 0x0200;
        public const int CONNECTION = 0x0300;
        public const int HRESIZE_HANDLE = 0x0400;
        public const int VRESIZE_HANDLE = 0x0500;
        public const int INLET = 0x0600;
        public const int OUTLET = 0x0700;
        public const int TEXT = 0x0800;

        public const int LOCATION_MASK = 0xff00;

        static public bool onUnknown(int squeack)
        {
            return (squeack & LOCATION_MASK) == UNKNOWN;
        }

        static public bool onBackground(int squeack)
        {
            return (squeack & LOCATION_MASK) == BACKGROUND;
        }

        static public bool onObject(int squeack)
        {
            return (squeack & LOCATION_MASK) == OBJECT;
        }

        static public bool onConnection(int squeack)
        {
            return (squeack & LOCATION_MASK) == CONNECTION;
        }

        static public bool onHResizeHandle(int squeack)
        {
            return (squeack & LOCATION_MASK) == HRESIZE_HANDLE;
        }

        static public bool onVResizeHandle(int squeack)
        {
            return (squeack & LOCATION_MASK) == VRESIZE_HANDLE;
        }

        static public bool onInlet(int squeack)
        {
            return (squeack & LOCATION_MASK) == INLET;
        }

        static public bool onOutlet(int squeack)
        {
            return (squeack & LOCATION_MASK) == OUTLET;
        }

        static public bool onText(int squeack)
        {
            return (squeack & LOCATION_MASK) == TEXT;
        }

        static public string describe(int squeack)
        {
            string action = "";
            string mod;
            string location = "";

            switch (squeack & MOUSE_MASK)
            {
                case MOVE:
                    action = "Move";
                    break;

                case DRAG:
                    action = "Drag";
                    break;

                case DOWN:
                    action = "Down";
                    break;

                case UP:
                    action = "Up";
                    break;

                case DOUBLE_CLICK:
                    action = "DoubleClick";
                    break;

                case POP_UP:
                    action = "PopUp";
                    break;
            }

            if (isShift(squeack))
                mod = "Shift";
            else
                mod = "";

            /*if (isCtrl(squeack))
            mod = "Ctrl";*/
            if (isShortcut(squeack))
                mod = "Shortcut";
            else
                mod = "";

            if (isMiddleButton(squeack))
                mod = "MiddleButton";
            else
                mod = "";

            if (isAlt(squeack))
                mod = "Alt";
            else
                mod = "";

            switch (squeack & LOCATION_MASK)
            {
                case BACKGROUND:
                    location = "OnBackground";
                    break;

                case OBJECT:
                    location = "OnObject";
                    break;

                case CONNECTION:
                    location = "OnConnection";
                    break;

                case INLET:
                    location = "OnInlet";
                    break;

                case OUTLET:
                    location = "OnOutlet";
                    break;

                case TEXT:
                    location = "OnText";
                    break;

                case HRESIZE_HANDLE:
                    location = "OnHResize";
                    break;

                case VRESIZE_HANDLE:
                    location = "OnVresize";
                    break;
            }

            return mod + action + location;
        }
    }
}