//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.objects;

namespace ircam.jmax.editors.patcher.interactions
{
    /// <summary>The interaction handling drag-select; 
    /// started by a click on the background;
    /// Note that since the proper event sequence is guaranteed by the
    /// input system (i.e. Down [Drag]* Up), we don't need to keep track
    /// of the status here, so we have no real state-machine.
    /// </summary>

    internal class VResizeInteraction : Interaction
    {
        internal GraphicObject obj;

        internal override void configureInputFilter(InteractionEngine filter)
        {
            filter.isFollowingMoves = true;
            filter.isAutoScrolling = true;
        }

        internal int dy;
        internal override void gotSqueack(ErmesSketchPad editor, int squeack, SensibilityArea area, Point mouse, Point oldMouse)
        {
            if (Squeack.isDown(squeack) && Squeack.onVResizeHandle(squeack))
            {
                obj = (GraphicObject)area.Target;
                //                editor.Cursor = System.Windows.Forms.Cursors.SizeNS;

                if ((!obj.isSelected) || ((obj.isSelected) && (ErmesSelection.patcherSelection.isSingleton())))
                    editor.setUndo("Resize", obj, false, false);
                else
                    editor.setUndo("Resize", false, false);
            }
            else if (Squeack.isDrag(squeack))
            {
                if ((!obj.isSelected) || ((obj.isSelected) && (ErmesSelection.patcherSelection.isSingleton())))
                {

                    obj.Redraw();
                    obj.redrawConnections();
                    obj.Height = (mouse.Y - obj.Y);
                    obj.Redraw();
                    obj.redrawConnections();
                }
                else
                {
                    if (ErmesSelection.patcherSelection.ownedBy(editor))
                    {
                        dy = mouse.Y - oldMouse.Y;
                        ErmesSelection.patcherSelection.apply(
                            delegate(GraphicObject gobj)
                            {
                                gobj.Redraw();
                                gobj.redrawConnections();
                                gobj.Height = (obj.Height + dy);
                                gobj.Redraw();
                                gobj.redrawConnections();
                            });
                    }
                }
                editor.fixSize();
            }
            else if (Squeack.isUp(squeack))
            {
                //                editor.Cursor = System.Windows.Forms.Cursors.Default;
                editor.endInteraction();
            }
        }
    }
}