//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;

using ircam.jmax.toolkit;
using ircam.jmax.editors.patcher;

namespace ircam.jmax.editors.patcher.objects
{
    //
    // The graphic pop-up menu used to change the number of an inlet or an outlet in a subpatcher.
    //

    public class ObjectPopUp
    {
        private static ObjectPopUp popup = new ObjectPopUp();
        private Hashtable subMenus;
        private Hashtable items;
        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //        public JMenuItem removeMenuItem, inspectItem;

        internal int x;
        internal int y;
        internal GraphicObject target = null;

        public ObjectPopUp()
        {

            //UNDONE: Constructor 'javax.swing.JPopupMenu.JPopupMenu' was not converted.
            //UNDONE: Constructor 'javax.swing.JMenuItem.JMenuItem' was not converted.
            //            removeMenuItem = new JMenuItem("Remove Connections");
            //            removeMenuItem.addActionListener(Actions.removeConnectionsAction);
            //            
            //UNDONE: Constructor 'javax.swing.JMenuItem.JMenuItem' was not converted.
            //            inspectItem = new JMenuItem("Inspect");
            ////            inspectItem.addActionListener(Actions.inspectObjectAction);
            //            
            //            add(Actions.bringToFrontObjectAction, "Bring To Front");
            //            add(Actions.sendToBackObjectAction, "Send To Back");
            //            
            //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
            //            pack();
            //            
            //UNDONE: Method 'javax.swing.JPopupMenu.addPopupMenuListener' was not converted.
            //            addPopupMenuListener(this);
        }

        internal bool separation = false;

        static public void addSeparation()
        {
            //            if (popup.inOutItemAdded)
            //                popup.insert(new Separator(), 3);
            //            else
            //                popup.insert(new Separator(), 2);
            popup.separation = true;
        }

        static public void removeSeparation()
        {
            if (popup.separation)
            {
                if (popup.inOutItemAdded)
                {
                    //UNDONE: Method 'javax.swing.JPopupMenu.remove' was not converted.
                    //                    popup.remove(3);
                }
                else
                {
                    //UNDONE: Method 'javax.swing.JPopupMenu.remove' was not converted.
                    //                    popup.remove(2);
                }

                popup.separation = false;
            }
        }

        internal bool inOutItemAdded = false;
        internal bool inspectAdded = false;

        static public void update(int where, string text, bool isInspectable)
        {
            //UNDONE: Method 'javax.swing.AbstractButton.setText' was not converted.
            //            popup.removeMenuItem.setText(text);
            switch (where)
            {
                case GraphicObject.ON_INLET:
                case GraphicObject.ON_OUTLET:
                    if (!popup.inOutItemAdded)
                    {
                        //                        popup.add(popup.removeMenuItem, 0);
                        popup.inOutItemAdded = true;
                    }
                    break;

                case GraphicObject.ON_OBJECT:
                default:
                    if (popup.inOutItemAdded)
                    {
                        //UNDONE: Method 'javax.swing.JPopupMenu.remove' was not converted.
                        //                        popup.remove(0);
                        popup.inOutItemAdded = false;
                    }
                    break;
            }

            /* inspect item handle */
            if (isInspectable)
            {
                if (!popup.inspectAdded)
                {
                    //                    popup.add(new Separator());
                    popup.separation = true;

                    //UNDONE: Method 'javax.swing.JPopupMenu.add' was not converted.
                    //                    popup.add(popup.inspectItem);
                    popup.inspectAdded = true;
                }
            }
            else
            {
                if (popup.inspectAdded)
                {
                    removeSeparation();
                    //                    popup.Controls.Remove(popup.inspectItem);
                    popup.inspectAdded = false;
                }
            }

            //UNDONE: Method 'javax.swing.JComponent.revalidate' was not converted.
            //            popup.revalidate();
            //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
            //            popup.pack();
        }

        static public GraphicObject PopUpTarget
        {
            get
            {
                return popup.target;
            }
        }

        static public ObjectPopUp Instance
        {
            get
            {
                return popup;
            }
        }

        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //        public static JMenuItem getMenuItem(string name)
        //        {
        //            return (JMenuItem) popup.items[name];
        //        }

        static public void Popup(System.Windows.Forms.Control invoker, GraphicObject obj, int x, int y)
        {
            popup.target = obj;
            popup.x = x;
            popup.y = y;

            //UNDONE: Method 'javax.swing.JPopupMenu.setPopupSize' was not converted.
            //            popup.setPopupSize(100, 200);
            //UNDONE: Method 'javax.swing.JPopupMenu.show' was not converted.
            //            popup.show(invoker, x - 2, y - 2);
        }

        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //        public JMenuItem add(EditorAction action, string name)
        //        {
        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //            JMenuItem item;
        //            
        //UNDONE: Constructor 'javax.swing.JMenuItem.JMenuItem' was not converted.
        //            item = new JMenuItem(name);
        //            item.addActionListener(action);
        //            SupportClass.PutElement(items, name, item);
        //UNDONE: Method 'javax.swing.JPopupMenu.add' was not converted.
        //            add(item);
        //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
        //            pack();
        //            
        //            return item;
        //        }

        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //        public static JMenuItem addItem(EditorAction action, string name)
        //        {
        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //            JMenuItem item;
        //            
        //UNDONE: Constructor 'javax.swing.JMenuItem.JMenuItem' was not converted.
        //            item = new JMenuItem(name);
        //            item.addActionListener(action);
        //            SupportClass.PutElement(popup.items, name, item);
        //UNDONE: Method 'javax.swing.JPopupMenu.add' was not converted.
        //            popup.add(item);
        //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
        //            popup.pack();
        //            
        //            return item;
        //        }

        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //        public static void addItem(JMenuItem item)
        //        {
        //UNDONE: Method 'javax.swing.JPopupMenu.add' was not converted.
        //            popup.add(item);
        //UNDONE: Method 'javax.swing.AbstractButton.getText' was not converted.
        //            SupportClass.PutElement(popup.items, item.getText(), item);
        //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
        //            popup.pack();
        //        }

        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //        public static JMenuItem addItem(EditorAction action, string name, string menuName)
        //        {
        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //            JMenuItem item;
        //UNDONE: Class 'javax.swing.JMenu' was not converted.
        //            JMenu menu;
        //            
        //UNDONE: Class 'javax.swing.JMenu' was not converted.
        //            menu = (JMenu) popup.subMenus[menuName];
        //            if (menu == null)
        //                menu = addMenu(menuName);
        //            
        //UNDONE: Constructor 'javax.swing.JMenuItem.JMenuItem' was not converted.
        //            item = new JMenuItem(name);
        //            item.addActionListener(action);
        //UNDONE: Method 'javax.swing.JMenu.add' was not converted.
        //            menu.add(item);
        //            
        //            return item;
        //        }

        //UNDONE: Class 'javax.swing.JMenu' was not converted.
        //        public static JMenu addMenu(string name)
        //        {
        //UNDONE: Class 'javax.swing.JMenu' was not converted.
        //            JMenu menu;
        //            
        //            //      if (name.charAt(0) == '%')
        //            //        {
        //            //      menu = new JMenu();
        //            //      menu.setIcon( Icons.get(name));
        //            //        }
        //            //      else
        //UNDONE: Constructor 'javax.swing.JMenu.JMenu' was not converted.
        //            menu = new JMenu(name);
        //            
        //UNDONE: Method 'javax.swing.JPopupMenu.add' was not converted.
        //            popup.add(menu);
        //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
        //            popup.pack();
        //            SupportClass.PutElement(popup.subMenus, name, menu);
        //            
        //            return menu;
        //        }

        //UNDONE: Class 'javax.swing.JMenu' was not converted.
        //        public static void addMenu(JMenu menu)
        //        {
        //UNDONE: Method 'javax.swing.JPopupMenu.add' was not converted.
        //            popup.add(menu);
        //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
        //            popup.pack();
        //UNDONE: Method 'javax.swing.AbstractButton.getText' was not converted.
        //            SupportClass.PutElement(popup.subMenus, menu.getText(), menu);
        //        }

        //UNDONE: Class 'javax.swing.JMenu' was not converted.
        //        public static void removeMenu(JMenu menu)
        //        {
        //            popup.Controls.Remove(menu);
        //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
        //            popup.pack();
        //UNDONE: Method 'javax.swing.AbstractButton.getText' was not converted.
        //            SupportClass.HashtableRemove(popup.subMenus, menu.getText());
        //        }

        //UNDONE: Class 'javax.swing.JMenuItem' was not converted.
        //        public static void removeItem(JMenuItem item)
        //        {
        //            popup.Controls.Remove(item);
        //UNDONE: Method 'javax.swing.AbstractButton.getText' was not converted.
        //            SupportClass.HashtableRemove(popup.items, item.getText());
        //UNDONE: Method 'javax.swing.JPopupMenu.pack' was not converted.
        //            popup.pack();
        //        }

        //PopupMenuListener interface
        //UNDONE: Class 'javax.swing.event.PopupMenuEvent' was not converted.
        //        public void popupMenuCanceled(PopupMenuEvent e)
        //        {
        //        }

        //UNDONE: Class 'javax.swing.event.PopupMenuEvent' was not converted.
        //        public void popupMenuWillBecomeInvisible(PopupMenuEvent e)
        //        {
        //            target.popUpReset();
        //        }

        //UNDONE: Class 'javax.swing.event.PopupMenuEvent' was not converted.
        //        public void popupMenuWillBecomeVisible(PopupMenuEvent e)
        //        {
        //        }
    }
}