//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.jmax;
using ircam.jmax.editors.patcher.interactions;

namespace ircam.jmax.editors.patcher.objects
{
    public class SensibilityArea
    {
        // Sensibility area are stored in a pool.

        // Stack of availables instances

        private static MaxVector pool = new MaxVector();

        // top of stack, pointer to next avaible free place

        internal static int top = 0;

        static public SensibilityArea getSensibilityArea(object target, int squeack)
        {
            if (top == 0)
                return new SensibilityArea(target, squeack);
            else
            {
                SensibilityArea area;

                top = top - 1;
                area = (SensibilityArea)pool[top];
                area.target = target;
                area.squeack = squeack;
                area.cost = 0;
                area.transparent = false;
                area.number = 0;

                return area;
            }
        }

        private bool transparent;
        private int cost;
        private int squeack;
        private object target;
        private int number;

        public override string ToString()
        {
            return ("SensibilityArea<" + (transparent ? "transparent, " : "nonTransparent, ") +
                target + ", " + ircam.jmax.editors.patcher.interactions.Squeack.describe(squeack) + "," + number + "," + cost + ">");
        }

        internal SensibilityArea(object target, int squeack)
        {
            this.target = target;
            this.squeack = squeack;
            cost = 0;
            transparent = false;
            number = 0;
        }

        // Sensibility area should be disposed to be reused

        public void Dispose()
        {
            pool.Size = top + 1;
            pool[top] = this;
            top = top + 1;
        }

        public bool isTransparent
        {
            get
            {
                return transparent;
            }
            set
            {
                transparent = value;
            }
        }

        public int Cost
        {
            get
            {
                return cost;
            }
            set
            {
                cost = value;
            }
        }

        public object Target
        {
            get
            {
                return target;
            }
            set
            {
                target = value;
            }
        }

        public int Number
        {
            get
            {
                return number;
            }
            set
            {
                number = value;
            }
        }

        public int ASqueack
        {
            get
            {
                return squeack;
            }
            set
            {
                squeack = value;
            }
        }
    }
}