//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;
using System.Windows.Forms;

using ircam.jmax;
using ircam.jmax.fts;
using ircam.jmax.editors.patcher;
using ircam.jmax.editors.patcher.interactions;
using ircam.jmax.toolkit;

namespace ircam.jmax.editors.patcher.objects
{
    public class Standard : Editable
    {
        private string varName = null;
        private int varWidth = 0;

        //--------------------------------------------------------
        // CONSTRUCTOR
        //--------------------------------------------------------
        public Standard(FtsGraphicObject theFtsObject) : base(theFtsObject) { }

        // ----------------------------------------
        // ``Args'' property
        // ----------------------------------------
        public override string Args
        {
            get
            {
                return ftsObject.Description;
            }
        }

        public override void redefine(string text)
        {
            ((FtsPatcherObject)ftsObject.Parent).RequestRedefineObject(ftsObject, text);
        }

        public override void editContent()
        {
            if (!ftsObject.IsError)
            {
                if (ftsObject is FtsObjectWithEditor)
                {
                    itsSketchPad.waiting();

                    if (ftsObject is FtsPatcherObject)
                        ((FtsPatcherObject)ftsObject).RequestSubPatcherUpload();
                    else
                        ((FtsObjectWithEditor)ftsObject).RequestOpenEditor();

                    ((FtsPatcherObject)ftsObject.Parent).RequestStopWaiting();
                }
                else
                    ftsObject.SendDoubleClick();
            }
        }

        public override bool hasContent
        {
            get
            {
                return true;
            }
        }

        public override string CurrentName
        {
            set
            {
                if (value.Equals(""))
                {
                    varName = "";
                    varWidth = 0;
                }
                else
                {
                    varName = value;
                    //UNDONE: Method 'java.awt.FontMetrics.stringWidth' was not converted.
                    //                    varWidth = FontMetrics.stringWidth(varName) + 6;
                }

                Redraw();
            }
        }

        public override string Name
        {
            get
            {
                return varName;
            }
        }

        public override Font AFont
        {
            get
            {
                return base.AFont;
            }
            set
            {
                base.AFont = value;
                if ((object)varName != null && !varName.Equals(""))
                {
                    int oldw = Width - varWidth;
                    //UNDONE: Method 'java.awt.FontMetrics.stringWidth' was not converted.
                    //                varWidth = FontMetrics.stringWidth(varName) + 6;
                }
            }
        }


        public override void setCurrentFont(Font theFont)
        {
            //base.setCurrentFont(theFont);
            //if ((object)varName != null)
            //{
            //    int oldw = Width - varWidth;
            //    //UNDONE: Method 'java.awt.FontMetrics.stringWidth' was not converted.
            //    //                varWidth = FontMetrics.stringWidth(varName) + 6;
            //    setWidth(oldw + varWidth);
            //}
        }

        public override int VariableWidth
        {
            get
            {
                return varWidth;
            }
        }

        // ----------------------------------------
        // Text area offset
        // ----------------------------------------

        private const int TEXT_X_OFFSET = 3; /*was 4 */
        private const int TEXT_Y_OFFSET = 2;

        public override int TextXOffset
        {
            get
            {
                return TEXT_X_OFFSET;
            }
        }

        public override int TextYOffset
        {
            get
            {
                return TEXT_Y_OFFSET;
            }
        }

        public override int TextWidthOffset
        {
            get
            {
                return 5;
            }
        }

        public override int TextHeightOffset
        {
            get
            {
                return 5;
            }
        }

        public override Color TextForeground
        {
            get
            {
                if (ftsObject.IsError)
                    return Color.Gray;
                else
                    return Color.Black;
            }
        }

        public override Color TextBackground
        {
            get
            {
                if (isSelected)
                    if (ftsObject.IsError)
                        return Color.LightGray;
                    else if (ftsObject.Persistent == 1)
                        return persistColor;
                    else
                        return Settings.sharedInstance.ObjColor;
                else if (Editing)
                    return Settings.sharedInstance.EditBackgroundColor;
                else
                    return Color.White;
            }
        }

        public override bool isMultiline
        {
            get
            {
                return true;
            }
        }

        // ----------------------------------------
        // Paint stuff
        // ----------------------------------------

        public override void Paint(Graphics g)
        {
            Color color;

            if (ftsObject.IsError)
            {
                if (isSelected)
                    color = Color.Gray;
                else
                    color = Color.LightGray;
            }
            else
            {
                if (ftsObject.Persistent == 1)
                    if (isSelected)
                        color = selPersistColor;
                    else
                        color = persistColor;
                else if (isSelected)
                {
                    color = ControlPaint.Dark(Settings.sharedInstance.ObjColor);
                }
                else
                    color = Settings.sharedInstance.ObjColor;
            }

            int x = X;
            int y = Y;
            int w = Width - varWidth;
            int h = Height;

            g.FillRectangle(new SolidBrush(color), x + 1, y + 1, w - 2, h - 2);

            DrawContent(g);

            /* draw variable name */

            if ((object)varName != null)
            {
                if (ftsObject.Persistent == 1)
                    if (isSelected)
                        color = selVarPersistColor;
                    else
                        color = varPersistColor;
                else if (isSelected)
                    color = selVarColor;
                else
                    color = varColor;

                g.FillRectangle(new SolidBrush(color), x + w, y + 1, varWidth - 1, h - 2);

                if (ftsObject.Persistent == 1)
                    if (isSelected)
                        color = selPersistColor;
                    else
                        color = persistColor;
                else
                    if (isSelected)
                        ControlPaint.Dark(Settings.sharedInstance.ObjColor);
                    else
                        color = Settings.sharedInstance.ObjColor;

                g.DrawLine(new Pen(color), x + w - 2, y + 1, x + w - 2, y + h - 2);
                g.DrawLine(new Pen(TextForeground), x + w - 1, y + 1, x + w - 1, y + h - 2);
                g.DrawString(varName, AFont, new SolidBrush(TextForeground), x + w + 2, y + AFont.Height + (h - AFont.Height) / 2);
            }

            base.Paint(g);
        }

        public override IObjectControlPanel ControlPanel
        {
            get
            {
                return new StandardControlPanel(this);
            }
        }

        public override bool isInspectable
        {
            get
            {
                return ((ftsObject.Persistent != -1) || ((object)varName != null));
            }
        }

        internal Color varColor = Color.FromArgb(153, 204, 204, 100);
        internal Color selVarColor = Color.FromArgb(107, 142, 142, 100);
        internal Color persistColor = Color.FromArgb(230, 230, 40);
        internal Color selPersistColor = Color.FromArgb(178, 178, 40);
        internal Color varPersistColor = Color.FromArgb(230, 230, 40, 100);
        internal Color selVarPersistColor = Color.FromArgb(178, 178, 40, 100);
    }
}