using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using ircam.jmax.fts;

namespace ircam.jmax.editors.project
{
	public partial class NewProjectDialog: Form
	{
		public NewProjectDialog()
		{
			InitializeComponent();

            this.copyCheckBox.Checked = true;
            InitializeTextBox();
		}

        private void InitializeTextBox()
        {
            string path = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            pathComboBox.Text = path;
            pathComboBox.Items.Add(path);

            int num = 1;

        search: FileInfo file = new FileInfo(path + "\\" + "NewProject" + num.ToString() + ".jprj");
            if (file.Exists)
            {
                num++;
                goto search;
            }

            nameTextBox.Text = "NewProject" + num.ToString();
        }

        private void LabelTextChanged(object sender, System.EventArgs e)
        {
            if (nameTextBox.Text == "")
            {
                infoLabel.Visible = false;
                fullNameLabel.Visible = false;
            }
            else
            {
                infoLabel.Visible = true;
                fullNameLabel.Visible = true;
            }

            fullNameLabel.Text = pathComboBox.Text + "\\" + nameTextBox.Text.TrimEnd('.') + ".";

            const int w = 350;

            Graphics g = fullNameLabel.CreateGraphics();
            SizeF size = g.MeasureString(fullNameLabel.Text, fullNameLabel.Font, w);

            fullNameLabel.Width = (int)Math.Ceiling(size.Width);
            fullNameLabel.Height = (int)Math.Ceiling(size.Height);

            g.Dispose();
        }

        public string ResultName
        {
            get
            {
                string name = this.nameTextBox.Text;

                if (!name.EndsWith(".jprj"))
                    name = string.Concat(name, ".jprj");

                return name;
            }
        }

        public string ResultLocation
        {
            get
            {
                string location = this.pathComboBox.Text;
                if (!location.EndsWith("/"))
                    location = string.Concat(location, "/");
                return location;
            }
        }

        public bool CopyCurrentProject()
        {
            return this.copyCheckBox.Checked;
        }


        private void browseButton_Click(object sender, System.EventArgs e)
        {
            folderBrowserDialog.Description = "Project Location";

            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                pathComboBox.Text = folderBrowserDialog.SelectedPath;
                pathComboBox.Items.Add(pathComboBox.Text);
            }
        }

        private void okButton_Click(object sender, System.EventArgs e)
        {
            FtsProject newProject = null;
            string name = ResultName;
            string location = ResultLocation;
            string fileName = location + name;

            ProjectEditor.CloseWindowsAndSave();

            if (!CopyCurrentProject())
            {
                try
                {
                    newProject = new FtsProject();
                }
                catch (IOException ex)
                {
                    Console.Error.WriteLine("[ProjectEditor]: Error in FtsProject creation!");
                    Console.Error.WriteLine(ex.StackTrace);
                }
                newProject.Save(fileName);
                newProject.FileName = fileName;
                newProject.Dir = location;
                JMaxLibrary.Project = newProject;
                newProject.SetAsCurrentProject();
            }
            else
            {
                /* save a copy of current project */
                JMaxLibrary.Project.Save(fileName);

                /* load the copy */
                try
                {
                    JMaxLibrary.LoadProject(fileName);
                }
                catch (IOException ex)
                {
                    Console.Error.WriteLine("[ProjectEditor]: I/O error loading project " + fileName);
                }
            }
        }

        private void cancelButton_Click(object sender, System.EventArgs e)
        {
            this.Close();
            this.Dispose();
        }
	}
}