//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.fts.client;
using ircam.jmax;

namespace ircam.jmax.fts
{
    /// <summary> Implement an interface to the FTS clipboard.
    /// Support two methods: copy from a FtsSelection, and paste to an FtsContainer 
    /// </summary>

    public class FtsClipboard : FtsObject
    {
        /*****************************************************************************/
        /*                                                                           */
        /*                               CONSTRUCTORS                                */
        /*                                                                           */
        /*****************************************************************************/

        /// <summary> Create a Fts clipboard;</summary>

        protected internal FtsArgs args = new FtsArgs();
        private bool empty = true; // Empty only before its first copy
        private int copyCount = 0;

        public FtsClipboard()
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("__clipboard")) { }

        public void Copy(FtsSelection sel)
        {
            args.Clear();
            args.Add(sel);

            try
            {
                Send(FtsSymbol.Get("copy"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsClipboard]: I/O Error sending copy message!");
                Console.Error.WriteLine(e.StackTrace);
            }

            empty = false;
            copyCount++;
        }

        public void Paste(FtsObject patcher)
        {
            args.Clear();
            args.Add(patcher);

            try
            {
                Send(FtsSymbol.Get("paste"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsClipboard]: I/O Error sending paste message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public int CopyCount
        {
            get
            {
                return copyCount;
            }
        }

        public bool IsEmpty
        {
            get
            {
                return empty;
            }
        }
    }
}