//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.fts.client;
using ircam.jmax;
using ircam.jmax.editors.configuration;

namespace ircam.jmax.fts
{
    public class FtsConfig : FtsObjectWithEditor
    {
        new protected internal FtsArgs args = new FtsArgs();

        static FtsConfig()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsConfig), FtsSymbol.Get("midi_config"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsConfig)obj).MidiConfig = new FtsMidiConfig(JMaxLibrary.FtsServer,
                                                                    JMaxLibrary.RootPatcher,
                                                                    args.GetInt(0));
                });
            FtsObject.RegisterMessageHandler(typeof(FtsConfig), FtsSymbol.Get("audio_config"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsConfig)obj).AudioConfig = new FtsAudioConfig(JMaxLibrary.FtsServer,
                                                                      JMaxLibrary.RootPatcher,
                                                                      args.GetInt(0));
                });
            FtsObject.RegisterMessageHandler(typeof(FtsConfig), FtsSymbol.Get("name"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsConfig)obj).FileName = args.GetSymbol(0).ToString();
                });
            FtsObject.RegisterMessageHandler(typeof(FtsConfig), FtsSymbol.Get("setDirty"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsConfig)obj).IsDirty = args.GetInt(0) == 1;
                });
        }

        public FtsConfig(FtsServer server, FtsObject parent, int id) 
            : base(server, parent, id) { }

        public FtsConfig() 
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("__config")) { }

        internal FtsMidiConfig MidiConfig
        {
            get
            {
                return midiConfig;
            }
            set
            {
                midiConfig = value;
            }
        }

        internal FtsAudioConfig AudioConfig
        {
            get
            {
                return audioConfig;
            }
            set
            {
                audioConfig = value;
            }
        }

        public void Upload()
        {
            try
            {
                Send(FtsSymbol.Get("upload"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsConfig: I/O Error sending upload Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void Save(string fileName)
        {
            args.Clear();
            args.AddSymbol(FtsSymbol.Get(fileName));
            try
            {
                Send(FtsSymbol.Get("save"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsConfig: I/O Error sending save Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void SaveAsDefault()
        {
            try
            {
                Send(FtsSymbol.Get("save_as_default"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsConfig: I/O Error sending saveAsDefault Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

//        public void Load(string fileName)
//        {
//            args.Clear();
//            args.AddSymbol(FtsSymbol.Get(fileName));
//            try
//            {
//                Send(FtsSymbol.get("load"), args);
//            }
//            catch (IOException e)
//            {
//                Console.Error.WriteLine("FtsConfig: I/O Error sending load Message!");
//                Console.Error.WriteLine(e.StackTrace);
//            }
//        }

        public override void OpenEditor(int nArgs, FtsAtom[] args)
        {
            if (EditorForm == null)
                EditorForm = new ConfigurationEditor();

            ShowEditor();
        }

        public override void DestroyEditor()
        {
            DisposeEditor();
        }

        public bool IsDirty
        {
            get
            {
                return dirty;
            }
            set
            {
                this.dirty = dirty;
            }
        }

        public string FileName
        {
            get
            {
                return fileName;
            }
            set
            {
                this.fileName = value;
            }
        }

        private string fileName = null;
        private bool dirty = false;
        private FtsMidiConfig midiConfig = null;
        private FtsAudioConfig audioConfig = null;
    }
}