//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.jmax;
using ircam.fts.client;

namespace ircam.jmax.fts
{
    /// <summary>Object set class.
    /// 
    /// </summary>
    public class FtsErrorFinderObject : FtsObject
    {
        protected internal FtsArgs args = new FtsArgs();

        public FtsErrorFinderObject()
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("__errorfinder")) { }

        public void FindErrors(FtsObjectSet ftsObjectSet)
        {
            FindErrors(JMaxLibrary.RootPatcher, ftsObjectSet);
        }

        public void FindErrors(FtsObject context, FtsObjectSet ftsObjectSet)
        {
            args.Clear();
            args.Add(ftsObjectSet);
            args.Add(context);
            try
            {
                Send(FtsSymbol.Get("error_finder_find"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsErrorFinderObject]: I/O Error sending error_find message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }
    }
}