//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.fts.client;
using ircam.jmax;

namespace ircam.jmax.fts
{
    /// <summary>Object set class.
    /// 
    /// </summary>
    public class FtsFinderObject : FtsObject
    {
        public FtsFinderObject() 
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("__finder")) { }

        public void find(FtsObjectSet obj, string query)
        {
            find(JMaxLibrary.RootPatcher, obj, query);
        }

        public void find(FtsObject context, FtsObjectSet obj, string query)
        {
            args.Clear();
            args.Add(obj);
            args.Add(context);
            args.AddRawString(query);

            try
            {
                Send(FtsSymbol.Get("finder_find"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsFinderObject]: I/O Error sending find message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void findFriends(FtsObject target, FtsObjectSet obj)
        {
            args.Clear();
            args.Add(obj);
            args.Add(target);

            try
            {
                Send(FtsSymbol.Get("finder_find_friends"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsFinderObject]: I/O Error sending find_friends message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        protected internal FtsArgs args = new FtsArgs();
    }
}