//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.fts.client;
using ircam.jmax;

namespace ircam.jmax.fts
{
    /// <summary>Object set class.
    /// 
    /// </summary>
    public class FtsObjectSet : FtsObject
    {
        internal MaxVector list, dataListeners;
        internal IFtsEditListener editListener;

        internal class ObjectSetEditListener : IFtsEditListener
        {
            public ObjectSetEditListener(FtsObjectSet ftsObjectSet)
            {
                this.ftsObjectSet = ftsObjectSet;
            }

            public void ObjectAdded(FtsObject ftsObject) { }
            public void ObjectRemoved(FtsObject ftsObject)
            {
                ftsObjectSet.list.RemoveElement(ftsObject);
                ftsObjectSet.FireListChanged();
            }
            public void ConnectionAdded(FtsConnection connection) { }
            public void ConnectionRemoved(FtsConnection connection) { }
            public void AtomicAction(bool active) { }

            FtsObjectSet ftsObjectSet;
        }

        static FtsObjectSet()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsObjectSet), FtsSymbol.Get("clear"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsObjectSet)obj).Clear();
                });
            FtsObject.RegisterMessageHandler(typeof(FtsObjectSet), FtsSymbol.Get("append"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsObjectSet)obj).Append(args);
                });
            FtsObject.RegisterMessageHandler(typeof(FtsObjectSet), FtsSymbol.Get("remove"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsObjectSet)obj).RemoveObject(args.GetObject(0));
                });
        }

        public FtsObjectSet()
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("__objectset"))
        {
            list = new MaxVector();
            dataListeners = new MaxVector();

            editListener = new ObjectSetEditListener(this);
            FtsPatcherObject.AddGlobalEditListener(editListener);
        }

        public void Release()
        {
            FtsPatcherObject.RemoveGlobalEditListener(editListener);
        }

        public void Append(FtsArgs args)
        {
            for (int i = 0; i < args.Length; i++)
                list.AddElement(args.GetObject(i));

            FireListChanged();
        }

        public void Clear()
        {
            list.RemoveAllElements();
            FireListChanged();
        }

        public void RemoveObject(FtsObject obj)
        {
            list.RemoveElement(obj);
            FireListChanged();
        }

        /// <summary>listmodel interface </summary>
        public object this[int index]
        {
            get
            {
                return list[index];
            }
        }

        public int Size
        {
            get
            {
                return list.Size;
            }
        }

        public void AddListDataListener(IListDataListener l)
        {
            dataListeners.AddElement(l);
        }

        public void RemoveListDataListener(IListDataListener l)
        {
            dataListeners.RemoveElement(l);
        }

        private void FireListChanged()
        {
            for (System.Collections.IEnumerator e = dataListeners.Elements(); e.MoveNext(); )
            {
                ((IListDataListener)e.Current).ContentsChanged();
            }
        }
    }
}