//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;
using System.Windows.Forms;

using ircam.fts.client;
using ircam.jmax.toolkit;
using ircam.jmax.editors.patcher;

namespace ircam.jmax.fts
{
    public abstract class FtsObjectWithEditor : FtsUndoableObject
    {
        static FtsObjectWithEditor()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsObjectWithEditor), FtsSymbol.Get("openEditor"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsObjectWithEditor)obj).OpenEditor(args.Length, args.Atoms);
                });
            FtsObject.RegisterMessageHandler(typeof(FtsObjectWithEditor), FtsSymbol.Get("destroyEditor"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsObjectWithEditor)obj).DestroyEditor();
                });
            FtsObject.RegisterMessageHandler(typeof(FtsObjectWithEditor), FtsSymbol.Get("closeEditor"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsObjectWithEditor)obj).CloseEditor();
                });
        }

        public FtsObjectWithEditor(FtsServer server, FtsObject parent, int id, string className, FtsAtom[] args, int offset, int length)
            : base(server, parent, id, className, args, offset, length) { }

        public FtsObjectWithEditor(FtsServer server, FtsObject parent, int id, string className, string description)
            : base(server, parent, id, className, description) { }

        public FtsObjectWithEditor(FtsServer server, FtsObject parent, int id) : base(server, parent, id) { }

        public FtsObjectWithEditor(FtsServer server, FtsObject parent, FtsSymbol className) : base(server, parent, className) { }

        public Form EditorForm
        {
            get
            {
                return editorForm;
            }
            set
            {
                editorForm = value;
            }
        }

        public void DisposeEditor()
        {
            if (editorForm != null)
            {
                HideEditor();

                if (editorForm != null)
                    editorForm.Dispose();
                editorForm = null;
            }
        }

        public void ShowEditor()
        {
            if (editorForm != null)
                if (!editorForm.Visible)
                {
                    editorForm.ShowDialog();
                }


            if (editorForm.WindowState == FormWindowState.Minimized)
            {
                editorForm.WindowState = FormWindowState.Normal;
            }
            editorForm.BringToFront();
        }

        public void HideEditor()
        {
            editorForm.Visible = false;
            MaxWindowManager.WindowManager.RemoveWindow(editorForm);
        }

        public void CloseEditor()
        {
            if (editorForm != null)
                HideEditor();
        }

        internal void ReleaseData()
        {
            RequestDestroyEditor();
        }

        public void RequestDestroyEditor()
        {
            try
            {
                Send(FtsSymbol.Get("destroyEditor"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsObjectWithEditor: I/O Error sending destroyEditor Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void RequestOpenEditor()
        {
            try
            {
                Send(FtsSymbol.Get("openEditor"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsObjectWithEditor: I/O Error sending OpenEditor Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public abstract void OpenEditor(int argc, FtsAtom[] argv);
        public abstract void DestroyEditor();

        [NonSerialized()]
        private Form editorForm = null;
    }
}