//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;
using System.Collections;

using ircam.fts.client;
using ircam.jmax;
using ircam.jmax.editors.project;

namespace ircam.jmax.fts
{
    public class FtsProject : FtsPackage
    {
        static FtsProject()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsProject), FtsSymbol.Get("require"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    ((FtsProject)obj).AddRequires(args.Length, args.Atoms);
                });

            FtsObject.RegisterMessageHandler(typeof(FtsProject), FtsSymbol.Get("config"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    string config = null;
                    if (args.Length == 1)
                        config = args.GetSymbol(0).ToString();

                    ((FtsProject)obj).CurrentConfig = config;
                });
        }

        public FtsProject() : base() { }

        public FtsProject(FtsServer server, FtsObject parent, int id) : base(server, parent, id) { }

        public override void AddPackage(string pkgName, int id)
        {
            base.AddPackage(pkgName, id);
            LoadPackage(pkgName, id);
        }

        internal void LoadPackage(string pkgName, int id)
        {
            FtsPackage ftsPkg;

            if (!packages.ContainsKey(pkgName))
            {
                try
                {
                    JMaxPackageLoader.Load(pkgName);
                }
                catch (JMaxPackageLoadingException e)
                {
                    JMaxLibrary.ReportException(e);
                }

                ftsPkg = new FtsPackage(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, id);
                packages.Add(pkgName, ftsPkg);
                ftsPkg.Upload();
            }
        }

        public void SetAsCurrentProject()
        {
            try
            {
                Send(FtsSymbol.Get("set_as_current_project"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsProject: I/O Error sending setAsCurrentProject Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public void SaveAsDefault()
        {
            try
            {
                Send(FtsSymbol.Get("save_as_default"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsProject: I/O Error sending saveAsDefault Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        public string Config
        {
            get
            {
                return config;
            }
            set
            {
                args.Clear();

                if (value != null)
                    args.AddSymbol(FtsSymbol.Get(value));

                try
                {
                    Send(FtsSymbol.Get("config"), args);
                }
                catch (IOException e)
                {
                    Console.Error.WriteLine("FtsProject: I/O Error sending setConfig Message!");
                    Console.Error.WriteLine(e.StackTrace);
                }
            }
        }

        public string CurrentConfig
        {
            set
            {
                config = value;
                if (listener != null)
                    listener.ConfigChanged(value);
            }
        }

        public void SaveWindows(IEnumerator windows)
        {
            FtsPatcherObject patch;

            args.Clear();

            for (IEnumerator e = windows; e.MoveNext(); )
            {
                patch = (FtsPatcherObject)e.Current;
                args.AddSymbol(FtsSymbol.Get(patch.Name));
            }

            try
            {
                Send(FtsSymbol.Get("save_windows"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("FtsProject: I/O Error sending saveWindows Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        private Hashtable packages = new Hashtable();
        private string config = null;
        public static ArrayList alreadyLoaded = new ArrayList();
    }
}