//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;

using ircam.jmax;
using ircam.fts.client;

namespace ircam.jmax.fts
{
    /// <summary> Implement the selection.
    /// Only one instance for server is built.
    /// </summary>
    public class FtsSelection : FtsObject
    {
        /*****************************************************************************/
        /*                                                                           */
        /*                               CONSTRUCTORS                                */
        /*                                                                           */
        /*****************************************************************************/

        /// <summary>The objects (and connections) selected in the patcher </summary>
        private MaxVector objects = new MaxVector();

        [NonSerialized()]
        protected internal FtsArgs args = new FtsArgs();

        /// <summary> Create a Fts selection;</summary>
        public FtsSelection()
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("__selection")) { }

        /// <summary>Add an object to this container  </summary>
        public void Add(FtsObject obj)
        {
            objects.AddElement(obj);

            args.Clear();
            args.Add(obj);

            try
            {
                Send(FtsSymbol.Get("add"), args);
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsSelection]: I/O Error sending add message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        /// <summary>Remove an object from this container. </summary>
        public void Remove(FtsObject obj)
        {
            if (objects.Contains(obj))
            {
                objects.RemoveElement(obj);

                args.Clear();
                args.Add(obj);

                try
                {
                    Send(FtsSymbol.Get("remove"), args);
                }
                catch (IOException e)
                {
                    Console.Error.WriteLine("[FtsSelection]: I/O Error sending remove message!");
                    Console.Error.WriteLine(e.StackTrace);
                }
            }
        }

        /// <summary>Get the objects </summary>
        public MaxVector Objects
        {
            get
            {
                return objects;
            }
        }

        /// <summary>clean: remove everything </summary>
        public void Clean()
        {
            objects.RemoveAllElements();

            try
            {
                Send(FtsSymbol.Get("clear"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsSelection]: I/O Error sending clean message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }
    }
}