//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.IO;
using System.Collections;

using ircam.fts.client;
using ircam.jmax;

namespace ircam.jmax.fts
{
    public class FtsUpdateGroup : FtsObject
    {
        static FtsUpdateGroup()
        {
            FtsObject.RegisterMessageHandler(typeof(FtsUpdateGroup), FtsSymbol.Get("update_group_begin"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    for (IEnumerator i = ((FtsUpdateGroup)obj).updateGroupList.GetEnumerator(); i.MoveNext(); )
                    {
                        ((IFtsUpdateGroupListener)i.Current).UpdateGroupStart();
                    }
                });

            FtsObject.RegisterMessageHandler(typeof(FtsUpdateGroup), FtsSymbol.Get("update_group_end"),
                delegate(FtsObject obj, FtsArgs args)
                {
                    for (IEnumerator i = ((FtsUpdateGroup)obj).updateGroupList.GetEnumerator(); i.MoveNext(); )
                    {
                        ((IFtsUpdateGroupListener)i.Current).UpdateGroupEnd();
                    }
                });
        }

        public FtsUpdateGroup()
            : base(JMaxLibrary.FtsServer, JMaxLibrary.RootPatcher, FtsSymbol.Get("update_group")) { }

        public void start()
        {
            try
            {
                Send(FtsSymbol.Get("start"));
            }
            catch (IOException e)
            {
                Console.Error.WriteLine("[FtsUpdateGroup]: I/O Error sending Start Message!");
                Console.Error.WriteLine(e.StackTrace);
            }
        }

        /* Sketchpad List */

        public void Add(IFtsUpdateGroupListener listener)
        {
            updateGroupList.Add(listener);
        }

        public void Remove(IFtsUpdateGroupListener listener)
        {
            updateGroupList.Remove(listener);
        }

        private ArrayList updateGroupList = new ArrayList();
    }
}