//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;

namespace ircam.jmax.toolkit
{
    /// <summary>A simple implementation of the Layer interface, with a default behaviour
    /// for the render method with Rectangle argument.
    /// See the Layer interface for a documentation on the Layer mechanism. 
    /// </summary>
    /// <seealso cref="Layer">
    /// </seealso>
    /// <seealso cref="RenderManager">
    /// </seealso>
    public abstract class AbstractLayer : ILayer
    {
        public abstract void Render(Graphics g, int order);

        /// <summary> The default implementation just ignores the rectangle </summary>
        public void Render(Graphics g, Rectangle r, int order)
        {
            Render(g, order);
        }

        /// <summary> The default implementation returns null </summary>
        public IObjectRenderer IObjectRenderer
        {
            get
            {
                return null;
            }
        }
    }
}