//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> A context switcher that is listening to mouseEnter events in a generic Component.
    /// It fires a context changed when the mouse enters the specified component.
    /// </summary>
    /// <seealso cref="WindowContextSwitcher">
    /// </seealso>
    /// <seealso cref="ContextSwitcher">
    /// </seealso>

    public class ComponentContextSwitcher : IContextSwitcher
    {
        /// <param name="component,">the component to listen to
        /// </param>
        /// <param name="gc,">the graphic context associated 
        /// </param>
        public ComponentContextSwitcher(Control component, GraphicContext gc)
        {
            this.component = component;
            this.gc = gc;
        }

        /*
        * Ask to be informed when Graphic context switch occurs */
        public void AddSwitchListener(ISwitchListener l)
        {
            listeners.Add(l);
        }

        /// <summary> Remove the given listener </summary>
        public void RemoveSwitchListener(ISwitchListener l)
        {
            listeners.Remove(l);
        }

        /// <summary> Returns the graphic context associated to this switcher </summary>
        /// <summary> Sets the GraphicContext that this switcher must handle </summary>
        public GraphicContext GC
        {
            get
            {
                return gc;
            }
            set
            {
                this.gc = value;
            }
        }

        //--- ComponentContextSwitcher fields
        internal Control component;
        internal GraphicContext gc;
        internal ArrayList listeners;
    }
}