//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> A simple interaction module to detect the direction of movement
    /// of the mouse during a drag, and to  communicate it to a DirectionListener.
    /// This class does not handle mouseDown, so it must be mounted
    /// when a mouseDown already happened.
    /// Warning: this module continuosly send direction informations during 
    /// mouseDrags, so do not left it active more then needed.
    /// </summary>
    public class DirectionChooser : InteractionModule
    {
        /// <summary> constructor with the direction listener</summary>
        public DirectionChooser(IDirectionListener theListener) : base()
        {
            itsListener = theListener;
        }

        /// <summary> sets the point to be considered as origin of the movement</summary>
        public override void InteractionBeginAt(int x, int y)
        {
            itsX = x;
            itsY = y;
            InteractionSemaphore.Lock();
        }

        //Mouse interface

        public void MouseDragged()
        {
            if (Math.Abs(Control.MousePosition.X - itsX) > Math.Abs(Control.MousePosition.Y - itsY))
                itsListener.DirectionChoosen(HORIZONTAL_MOVEMENT);
            else
                itsListener.DirectionChoosen(VERTICAL_MOVEMENT);
        }

        public void MouseReleased()
        {
            itsListener.DirectionAbort();
            InteractionSemaphore.Unlock();
        }

        //--- Fields
        internal IDirectionListener itsListener;
        internal int itsX;
        internal int itsY;

        public const int HORIZONTAL_MOVEMENT = 1;
        public const int VERTICAL_MOVEMENT = 2;
    }
}