//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;

namespace ircam.jmax.toolkit
{
    /// <summary> A specific component used as a container of JToggleButtons 
    /// corresponding to Tools. 
    /// The EditorToolbar class keeps a JPopupMenu with all the tools inserted;
    /// this Popup can be accessed and used as an alternative for choosing 
    /// a tool (example, right-mouse click). 
    /// </summary>
    //--------------------------------
    // implementation notes:
    // starting from 2.4.8, this class have been reduced to a simple 
    // graphic component that is able to select tools. The model for this
    // UI element is represented by the ToolManager class
    //--------------------------------

    public class EditorToolbar
    {
        /// <summary> constructor. It inserts the tools provided by the given
        /// ToolManager. The direction parameter specify if the
        /// toolbar should be HORIZONTAL or VERTICAL. 
        /// </summary>
        public EditorToolbar(ToolManager manager, int direction)
        {
            this.manager = manager;

            if (direction == VERTICAL)
            {
                //UNDONE: Not Implemented Yet.
            }

            //install the Tools in the Toolbar
            Tool aTool;

            for (IEnumerator e = manager.Tools; e.MoveNext(); )
            {
                aTool = (Tool)e.Current;
                AddTool(aTool);
            }
        }

        /// <summary> add a new tool in the toolbar (and in the popupMenu)</summary>
        private void AddTool(Tool theTool)
        {
            //UNDONE: Not Implemented Yet.
        }


        /// <summary> From the ActionListener interface, not for public use.
        /// called when a user selects a new tool via the toolbar's user interface.
        /// The new tool will work on the same graphic context then the old.
        /// </summary>
        public void ActionPerformed(object sender, EventArgs e)
        {
            object aSource = sender;
            Tool aTool = (Tool)itsTools[aSource];

            manager.ChangeTool(aTool);
        }

        //---- Fields and accessors

        internal Hashtable itsTools = new Hashtable();

        public const int VERTICAL = 0;
        public const int HORIZONTAL = 1;

        private ToolManager manager;
    }
}