//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

namespace ircam.jmax.toolkit
{
    /// <summary> implemented by data models with support for undo.</summary>
    /// <seealso cref="ircam.jmax.fts.FtsRemoteUndoableData">
    /// </seealso>
    public interface IUndoableData
    {
        /// <summary> tells the model to start an undo section </summary>
        void BeginUpdate();

        /// <summary> posts an undo edit in the buffers </summary>
        void PostEdit();

        /// <summary> terminates the undo critical section </summary>
        void EndUpdate();

        /// <summary> ask to undo the section </summary>
        void Undo();

        /// <summary> ask to redo the section </summary>
        void Redo();

        /// <summary> are we in the midst of an undoable section? </summary>
        bool IsInGroup
        {
            get;
        }
    }
}