//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> the class implementing a generic status bar .
    /// It implements the StatusBar interface
    /// </summary>
    public class InfoPanel : IStatusBar
    {
        /// <summary>constructor </summary>
        public InfoPanel()
        {
            //UNDONE: Not Implemented Yet.
        }

        /// <summary>Status bar interface </summary>
        public void Post(IStatusBarClient theClient, string message)
        {
            if (theClient.Icon != null)
            {
                //UNDONE: Not Implemented Yet.
            }
            //UNDONE: Not Implemented Yet.
        }

        /// <summary> used to add controllers to the status bar.
        /// The size of the controller will be adjusted to fit into the standard height 
        /// </summary>
        public void AddWidget(Control theWidget)
        {
            if (theWidget.Size.Height > INFO_HEIGHT - 6)
            {
                theWidget.Size = new Size(theWidget.Size.Width, INFO_HEIGHT - 6);
            }

            theWidget.Location = new Point(availablePosition, (INFO_HEIGHT - theWidget.Size.Height) / 2);

            widgets.Add(theWidget);

            availablePosition += theWidget.Size.Width + 2;
        }

        /// <summary> add a controllers to the status bar in the given position.
        /// The height of the controller will be adjusted to fit into the standard 
        /// height 
        /// </summary>
        public void AddWidgetAt(Control theWidget, int position)
        {
            if (position >= widgets.Count || position < 0)
            {
                AddWidget(theWidget);
                return;
            }

            Control c = (Control)widgets[position];
            int xposition = c.Location.X;

            theWidget.Location = new Point(xposition, 4);

            if (theWidget.Size.Height > INFO_HEIGHT - 8)
            {
                theWidget.Size = new Size(theWidget.Size.Width, INFO_HEIGHT - 8);
            }

            xposition += theWidget.Size.Width + 2;

            for (int i = position; i < widgets.Count; i++)
            {
                c = (Control)widgets[i];
                c.Location = new Point(xposition, c.Location.Y);
                xposition += c.Size.Width + 2;
            }

            widgets.Insert(position, theWidget);
            availablePosition = xposition;
        }

        /// <summary> remove a controller in the status bar </summary>
        //this implementation is stupid. Must use a better Layout instead
        public void RemoveWidget(Control theWidget)
        {
            int widgetIndex = widgets.IndexOf(theWidget);
            int xposition = ((Control)widgets[widgetIndex - 1]).Size.Width + 2;

            Control c;
            for (int i = widgetIndex + 1; i < widgets.Count; i++)
            {
                c = (Control)widgets[i];
                c.Location = new Point(xposition, c.Location.Y);
                xposition += c.Size.Width + 2;
            }

            widgets.Remove(theWidget);
        }

        public Size GetPreferredSize()
        {
            return GetMinimumSize();
        }

        public Size GetMinimumSize()
        {
            return infoSize;
        }

        public Size ScreenSize
        {
            get
            {
                return new Size(0, 0);
            }
        }

        //----- Fields
        public const int INFO_WIDTH = 300;
        public const int INFO_HEIGHT = 30;
        private const int INITIAL_AVAILABLE_POSITION = 10;

        internal Size infoSize;
        internal Font itsHeaderFont;
        internal Size headerPreferredSize;
        internal Size labelPreferredSize;

        internal ArrayList widgets = new ArrayList();
        internal int availablePosition;
    }
}