//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

namespace ircam.jmax.toolkit
{
    public class InteractionSemaphore
    {
        internal static bool IsLocked
        {
            get
            {
                return contextLocked;
            }
        }

        /// <summary>Locks the current graphic context, i.e., no switches can occur until
        /// the context is unlocked 
        /// </summary>
        public static void Lock()
        {
            contextLocked = true;
        }

        /// <summary>UnLocks the current graphic context. The last context switch asked and not served becomes
        /// the current one, if any 
        /// </summary>
        public static void Unlock()
        {
            contextLocked = false;
            if (lastCaller != null)
                lastCaller.Unlocked();
            lastCaller = null;
        }

        internal static ILockListener Caller
        {
            set
            {
                lastCaller = value;
            }
        }

        internal static ILockListener lastCaller;
        internal static bool contextLocked = false;
        //static InteractionSemaphore instance = new InteractionSemaphore();
    }
}