//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> This is a convenience class used to factorize the code needed
    /// to handle the "show popup" actions in a track (as well as
    /// in every component that is interested in this functionality).
    /// Since the showing of the popup must be handled by the (awt) component
    /// in which the mouse event originates, we are forced to make this class
    /// a graphic class (the processMouseEvent can't be delegated). We choose, arbitarly, to
    /// derive from JPanel). 
    /// This component can be used in two ways: 
    /// <ul>
    /// <li> deriving from it (you must override the getMenu() method!!!)  </li>
    /// <li> constructing it with a provider (PopupProvider)                         </li>
    /// </ul>
    /// </summary>
    public class PopupToolbarPanel : IPopupProvider
    {
        public PopupToolbarPanel()
        {
        }

        public PopupToolbarPanel(IPopupProvider provider)
        {
            this.provider = provider;
        }

        protected internal void ProcessMouseEvent(MouseEventArgs e)
        {
            //UNDONE: Not Implemented Yet.
            //if (e.isPopupTrigger())
            //{
            //    if (provider != null)
            //    {
            //        provider.Menu.show(e.getSource, e.getX() - 10, e.getY() - 10);
            //    }
            //    else
            //    {
            //         Menu.show(e.getSource, e.getX() - 10, e.getY() - 10);
            //    }
            //}
            //else
            //{
            //    base.processMouseEvent(e);
            //}
        }

        public void Menu()
        {
        }

        public IPopupProvider Provider
        {
            get
            {
                return provider;
            }
        }

        //--- Fields
        internal IPopupProvider provider;
    }
}