//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> A simple layout to assign proportional space to two components.
    /// Create it with a direction (X_AXIS, Y_AXIS) and a ratio.
    /// This layout assign a space to the first component
    /// equal to ratio*(parent's size)
    /// WARNING: this implementation does'nt take care
    /// of the parent's insets.
    /// </summary>

    public class ProportionalLayout
    {
        /// <summary> Simplest constructor: just specify the VERTICAL or HORIZONTAL direction
        /// and the percentage of space of the first component.
        /// The second one will receive 1-ratio space  
        /// </summary>
        public ProportionalLayout(int theType, float theRatio)
        {
            components = new Control[2];
            itsType = theType;
            itsRatio = theRatio;
        }

        /* LayoutManager interface. */
        public void AddLayoutComponent(string name, Control comp)
        {
            if (componentIndex == 2)
            {
                System.Console.Error.WriteLine("proportional layout error: trying to add more than two components");
            }
            else
                components[componentIndex++] = comp;
        }


        /* LayoutManager interface. */
        public void RemoveLayoutComponent(Control comp)
        {
            for (int i = 0; i < 2; i++)
            {
                if (components[i] == comp)
                {
                    components[i] = null;
                    return;
                }
            }

            System.Console.Error.WriteLine("proportional layout error: trying to remove a not existing component");
        }


        /* LayoutManager interface. */
        public Size PreferredLayoutSize(ContainerControl parent)
        {
            int temp;
            int maxWidth;
            int maxHeight;

            maxHeight = components[0].Size.Height > components[1].Size.Height ? components[0].Size.Height : components[1].Size.Height;

            maxWidth = components[0].Size.Width > components[1].Size.Width ? components[0].Size.Width : components[1].Size.Width;


            if (itsType == X_AXIS)
            {
                temp = components[0].Size.Width + components[1].Size.Width;

                return new Size((int)(temp * itsRatio), maxHeight);
            }
            else
            {
                temp = components[0].Size.Height + components[1].Size.Height;
                return new Size(maxWidth, (int)(temp * itsRatio));
            }
        }

        /* LayoutManager interface. */
        public Size MinimumLayoutSize(ContainerControl parent)
        {
            return PreferredLayoutSize(parent);
        }

        /* The Layout function */
        public void LayoutContainer(ContainerControl parent)
        {
            if (components[0] == null)
                return;
            if (itsType == X_AXIS)
            {
                components[0].Location = new Point(0, 0);
                components[0].Size = new Size((int)(parent.Size.Width * itsRatio), parent.Size.Height);
                components[1].Location = new Point(components[0].Size.Width, 0);
                components[1].Size = new Size((int)(parent.Size.Width * (1 - itsRatio)), parent.Size.Height);
            }
            else
            {
                components[0].Location = new Point(0, 0);
                components[0].Size = new Size(parent.Size.Width, (int)(parent.Size.Height * itsRatio));
                components[1].Location = new Point(0, components[0].Size.Height);
                components[1].Size = new Size(parent.Size.Width, (int)(parent.Size.Height * (1 - itsRatio)));
            }
        }

        //--- Fields
        internal Control[] components;
        internal float itsRatio;
        internal int componentIndex = 0;
        internal int itsType;

        public const int X_AXIS = 0;
        public const int Y_AXIS = 1;
    }
}