//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Drawing;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> The base class for tools: it handles the name and the icon,
    /// the mounting of the interaction modules, and their activation/deactivation.
    /// </summary>
    abstract public class Tool : IStatusBarClient
    {
        /// <summary> constructor </summary>
        public Tool(string theName, string theImageIcon)
        {
            Name = theName;
            Icon = theImageIcon;
            Cursor.Current = Cursors.Default;
        }

        /// <summary> called when this tool is "mounted" on a Graphic context.
        /// It switches the Graphic context and mount the default IM, if no one
        /// is currently active.
        /// </summary>
        public void ReActivate(GraphicContext theGc)
        {
            gc = theGc;
            MountIModule(DefaultIM);
        }

        /// <summary> override to return the default (initial) Interaction module</summary>
        abstract public InteractionModule DefaultIM
        {
            get;
        }

        /// <summary> called when this object is unmounted </summary>
        public void Deactivate()
        {
        }

        /// <summary> the method used to mount another interaction module in a tool</summary>
        static public void MountIModule(InteractionModule im)
        {
            currentInteractionModule = im;
            currentInteractionModule.TakeInteraction(gc);
        }

        /// <summary> the method used to mount an interaction module in a tool
        /// AND specify an initial point for the interaction.
        /// This method is used when the IM is mounted when the interaction
        /// is already begun.
        /// </summary>
        static public void MountIModule(InteractionModule im, int x, int y)
        {
            MountIModule(im);
            im.InteractionBeginAt(x, y);
        }

        /// <summary> returns its name</summary>
        /// <summary> sets its name</summary>
        public string Name
        {
            get
            {
                return itsName;
            }
            set
            {
                itsName = value;
            }
        }

        /// <summary> gets the icon</summary>
        /// <summary> sets its icon</summary>
        public string Icon
        {
            get
            {
                return itsIcon;
            }
            set
            {
                itsIcon = value;
            }
        }

        public Cursor GetCursor()
        {
            return cursor;
        }

        public void SetCursor(string icon)
        {
            this.cursor = new Cursor(icon);
        }

        //---- Fields
        internal string itsName;
        internal string itsIcon;
        protected internal static GraphicContext gc;
        internal static InteractionModule currentInteractionModule;
        internal Cursor cursor;
    }
}