//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;
using System.Collections;
using System.Windows.Forms;

namespace ircam.jmax.toolkit
{
    /// <summary> A context switcher that is listening to WindowEvents.
    /// It fires a context changed when the corrisponding window is activated.
    /// Closing the window generates a context destroyed event.
    /// </summary>
    /// <seealso cref="ComponentContextSwitcher">
    /// </seealso>
    /// <seealso cref="ContextSwitcher">
    /// </seealso>
    public class WindowContextSwitcher : IContextSwitcher
    {
        /// <param name="window,">the window to listen to
        /// </param>
        /// <param name="gc,">the graphic context associated 
        /// </param>
        public WindowContextSwitcher(Form window, GraphicContext gc)
        {
            this.window = window;
            this.gc = gc;
        }


        /// <summary>Utility function to notificate to listeners </summary>
        private void NotifyChanged(GraphicContext gc)
        {
            ISwitchListener l;

            for (IEnumerator e = listeners.GetEnumerator(); e.MoveNext(); )
            {
                l = (ISwitchListener)e.Current;
                l.ContextChanged(gc);
            }
        }

        /// <summary>Utility function to notificate to listeners </summary>
        private void NotifyDestroyed(GraphicContext gc)
        {
            ISwitchListener l;

            for (IEnumerator e = listeners.GetEnumerator(); e.MoveNext(); )
            {
                l = (ISwitchListener)e.Current;
                l.ContextDestroyed(gc);
            }
        }

        /*
        * Ask to be informed when Graphic context switch occurs */
        public void AddSwitchListener(ISwitchListener l)
        {
            listeners.Add(l);
        }

        /// <summary> Remove the given listener </summary>
        public void RemoveSwitchListener(ISwitchListener l)
        {
            listeners.Remove(l);
        }

        /// <summary> Returns the graphic context associated to this switcher </summary>
        /// <summary> Sets the GraphicContext that this switcher must handle </summary>
        public GraphicContext GC
        {
            get
            {
                return gc;
            }
            set
            {
                this.gc = value;
            }
        }

        //--- WindowContextSwitcher fields
        internal Form window;
        internal GraphicContext gc;
        internal ArrayList listeners;
    }
}