//
// jMax
// Copyright (C) 1994, 1995, 1998, 1999 by IRCAM-Centre Georges Pompidou, Paris, France.
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// See file LICENSE for further informations on licensing terms.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 

using System;

using ircam.jmax;
using ircam.jmax.fts;
using ircam.jmax.editors.patcher.objects;
using ircam.jmax.guiobj;
using ircam.fts.client;

public class Guiobj : IMaxPackage
{
	public void Load()
	{
        JMaxObjectCreator standardCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        {
            return new Standard(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        };

        //JMaxObjectCreator patcherCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Patcher(new FtsPatcherObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator inletCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Inlet(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator outletCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Outlet(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator forkCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Fork(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator jcommentCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Comment(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        JMaxObjectCreator messconstCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        {
            return new MessConst(new FtsMessConstObject(server, parent, objId, className, args, offset, length));
        };

        //JMaxObjectCreator buttonCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Bang(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator toggleCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Toggle(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator sliderCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Slider(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator intboxCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new IntBox(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator floatboxCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new FloatBox(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator displayCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Display(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator vecdisplayCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new VectorDisplay(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator matdisplayCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new MatDisplay(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator scopeCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Scope(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator monitorCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Monitor(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator xyPadCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new XYPad(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator defineCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Define(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        //JMaxObjectCreator inputCreator = delegate(FtsServer server, FtsObject parent, int objId, string className, FtsAtom[] args, int offset, int length)
        //{
        //    return new Input(new FtsGraphicObject(server, parent, objId, className, args, offset, length));
        //};

        JMaxClassMap.Add("standard", standardCreator, "\\icons\\standard.gif", "\\icons\\standard_cursor.gif", "standard", this);
        //JMaxClassMap.Add("jpatcher", patcherCreator, "\\icons\\jpatcher.gif", "\\icons\\jpatcher_cursor.gif", "patcher", this);
        //JMaxClassMap.Add("receive", inletCreator, "\\icons\\inlet.gif", "\\icons\\inlet_cursor.gif", "inlet label", this);
        //JMaxClassMap.Add("send", outletCreator, "\\icons\\outlet.gif", "\\icons\\outlet_cursor.gif", "outlet label", this);
        //JMaxClassMap.Add("define", defineCreator, "\\icons\\define.gif", "\\icons\\define_cursor.gif", "define", this);
        //JMaxClassMap.Add("fork", forkCreator, "\\icons\\fork.gif", "\\icons\\fork_cursor.gif", "fork", this);
        //JMaxClassMap.Add("jcomment", jcommentCreator, "\\icons\\jcomment.gif", "\\icons\\jcomment_cursor.gif", "comment", this);
        JMaxClassMap.Add("messconst", messconstCreator, "\\icons\\messconst.gif", "\\icons\\messconst_cursor.gif", "message", this);
        //JMaxClassMap.Add("button", buttonCreator, "\\icons\\button.gif", "\\icons\\button_cursor.gif", "bang", this);
        //JMaxClassMap.Add("toggle", toggleCreator, "\\icons\\toggle.gif", "\\icons\\toggle_cursor.gif", "toggle", this);
        //JMaxClassMap.Add("slider", sliderCreator, "\\icons\\slider.gif", "\\icons\\slider_cursor.gif", "slider", this);
        //JMaxClassMap.Add("xypad", xyPadCreator, "\\icons\\xypad.gif", "\\icons\\xypad_cursor.gif", "2D controller", this);
        //JMaxClassMap.Add("intbox", intboxCreator, "\\icons\\intbox.gif", "\\icons\\intbox_cursor.gif", "integer", this);
        //JMaxClassMap.Add("floatbox", floatboxCreator, "\\icons\\floatbox.gif", "\\icons\\floatbox_cursor.gif", "float", this);
        //JMaxClassMap.Add("display", displayCreator, "\\icons\\display.gif", "\\icons\\display_cursor.gif", "generic display", this);
        //JMaxClassMap.Add("vecdisplay", vecdisplayCreator, "\\icons\\vecdisplay.gif", "\\icons\\vecdisplay_cursor.gif", "vector display", this);
        //JMaxClassMap.Add("matdisplay", matdisplayCreator, "\\icons\\matdisplay.gif", "\\icons\\matdisplay_cursor.gif", "matrix display", this);
        //JMaxClassMap.Add("scope~", scopeCreator, "\\icons\\scope.gif", "\\icons\\scope_cursor.gif", "oscilloscope", this);
        //JMaxClassMap.Add("monitor~", monitorCreator, "\\icons\\monitor.gif", "\\icons\\monitor_cursor.gif", "monitor", this);
        //JMaxClassMap.Add("input~", inputCreator, "\\icons\\input.gif", "\\icons\\input_cursor.gif", "input", this);
	}
}