package jp.sourceforge.jpnvalidator.impl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.jpnvalidator.JapaneseValidator;
import jp.sourceforge.jpnvalidator.ValidatorResult;
import jp.sourceforge.jpnvalidator.util.SimpleStringUtil;
import jp.sourceforge.jpnvalidator.util.validator.JapaneseStringValidateUtil;

public class JapaneseValidatorImpl implements JapaneseValidator
{

	/**
	 * type method mapping config
	 */
	private static Map<Type, Method> typeMethodMapping = new HashMap<Type, Method>();

	static
	{
		// set type-method mapping
		try
		{
			for (Type type : Type.values())
			{
				// get method name
				// ex. Type.ASCII -> isAsciiOnly
				String methodName = "is"
						+ SimpleStringUtil.convertULCase2LCCase(type.toString()) + "Only";
				// add type method mapping
				typeMethodMapping.put(type, JapaneseStringValidateUtil.class.getMethod(
						methodName, String.class, ValidatorResult.class));
			}
		} catch (SecurityException e)
		{
			e.printStackTrace();
			throw new RuntimeException((Throwable) e);
		} catch (NoSuchMethodException e)
		{
			e.printStackTrace();
			throw new RuntimeException((Throwable) e);
		}
	}

	/**
	 * types to validate
	 */
	private Type[] types = null;

	/**
	 * setup valid type list
	 */
	public JapaneseValidator matches(Type... args)
	{
		this.types = args;
		return this;
	}

	/**
	 * set black list file
	 */
	public JapaneseValidator setBlackListFile(String resourcePathOrFilePath)
	{
		// TODO
		return this;
	}

	/**
	 * execute validation to string value
	 */
	public ValidatorResult validate(String targetStr) throws Exception
	{
		ValidatorResult result = null;
		for (Type type : types)
		{
			try
			{
				Method method = typeMethodMapping.get(type);
				result = (ValidatorResult) method.invoke(null, targetStr, result);
			} catch (IllegalArgumentException e)
			{
				e.printStackTrace();
				throw new RuntimeException((Throwable) e);
			} catch (IllegalAccessException e)
			{
				e.printStackTrace();
				throw new RuntimeException((Throwable) e);
			} catch (InvocationTargetException e)
			{
				e.printStackTrace();
				throw new RuntimeException((Throwable) e);
			}
		}
		return result;
	}

	/**
	 * execute validation to file content
	 */
	public ValidatorResult validate(File file) throws Exception
	{
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * execute simple validation to string value
	 */
	public boolean validateFast(String targetStr) throws Exception
	{
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * execute simple validation to file content
	 */
	public boolean validateFast(File file) throws Exception
	{
		// TODO Auto-generated method stub
		return false;
	}

}
