/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.jpnvalidator.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * FileResourceUtil<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class FileResourceUtil
{

	/**
	 * Close resource safely
	 * 
	 * @param is
	 *            InputStream resource object
	 */
	public static void close(InputStream is)
	{
		try
		{
			if (is != null)
				is.close();
		} catch (Exception ignore)
		{
		}
	}

	/**
	 * Close resource safely
	 * 
	 * @param isr
	 *            InputStreamReader resource object
	 */
	public static void close(InputStreamReader isr)
	{
		try
		{
			if (isr != null)
				isr.close();
		} catch (Exception ignore)
		{
		}
	}

	/**
	 * Close resource safely
	 * 
	 * @param br
	 *            BufferedReader resource object
	 */
	public static void close(BufferedReader br)
	{
		try
		{
			if (br != null)
				br.close();
		} catch (Exception e)
		{
		}
	}

	/**
	 * Close resource safely
	 * 
	 * @param bis
	 *            BufferedInputStream resource object
	 */
	public static void close(BufferedInputStream bis)
	{
		try
		{
			if (bis != null)
				bis.close();
		} catch (Exception e)
		{
		}
	}

}
