package jp.sourceforge.jpnvalidator.util.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.jpnvalidator.ValidatorResult;
import jp.sourceforge.jpnvalidator.constant.Encoding;
import jp.sourceforge.jpnvalidator.constant.FixedValue;

public class BlackListStringValidateUtil extends AbstractStringValidateUtil
{

	/*
	 * -------------------------------------------------------------------------
	 * Black List Check
	 * -------------------------------------------------------------------------
	 */

	/**
	 * Byte sets of black list characters
	 */
	private List<byte[]> blackListByteSetList;

	/**
	 * Constructor
	 * 
	 * @param blackListFilePath
	 *            black list file path
	 * @throws IOException
	 *             file read error
	 */
	public BlackListStringValidateUtil(String blackListFilePath) throws IOException
	{
		renewBlackListFile(blackListFilePath);
	}

	/**
	 * 
	 * renewBlackListFile
	 * 
	 * @param blackListFilePath
	 *            black list file path
	 * @throws IOException
	 *             file read error
	 */
	public void renewBlackListFile(String blackListFilePath) throws IOException
	{
		blackListByteSetList = new ArrayList<byte[]>();
		char[] charArr = reader.read2CharArray(blackListFilePath);
		int charArrLen = charArr.length;
		for (int i = 0; i < charArrLen; i++)
		{
			byte[] strBytes = String.valueOf(charArr[i]).getBytes(Encoding.MS932);
			blackListByteSetList.add(strBytes);
		}
	}

	/**
	 * Check String value does not include char in black list
	 * 
	 * @param str
	 *            target String value
	 * @return check result
	 */
	public boolean hasBlackListCharFast(String str)
	{
		return _checkAllCharsFast(str, _getExecuteMethod(FixedValue.UNDER_SCORE_STRING));
	}

	public ValidatorResult hasBlackListChar(String str)
	{
		return _checkAllChars(str, _getExecuteMethod(FixedValue.UNDER_SCORE_STRING), null);
	}

	public ValidatorResult hasBlackListChar(String str, ValidatorResult result)
	{
		return _checkAllChars(str, _getExecuteMethod(FixedValue.UNDER_SCORE_STRING),
				result);
	}

	@SuppressWarnings("unused")
	private boolean _hasBlackListChar(String each)
	{
		byte[] eachStrbytes = _getMS932ByteArray(each);
		if (_isDoubleByte(eachStrbytes))
		{
			int firstByte = _getHexDigit(eachStrbytes[0]);
			int secondByte = _getHexDigit(eachStrbytes[1]);
			for (byte[] blackListStrBytes : blackListByteSetList)
			{
				if (_isDoubleByte(blackListStrBytes)
						&& firstByte == _getHexDigit(blackListStrBytes[0])
						&& secondByte == _getHexDigit(blackListStrBytes[1]))
				{
					return true;
				}
			}
		} else
		{
			int firstByte = eachStrbytes[0];
			for (byte[] blackListStrBytes : blackListByteSetList)
			{
				if (!_isDoubleByte(blackListStrBytes)
						&& firstByte == blackListStrBytes[0])
				{
					return true;
				}
			}
		}
		return false;
	}

}
