--TEST--
Bug #49785 (insufficient input string validation of htmlspecialchars())
--FILE--
<?php
function _bin2hex($val) {
    return is_string($val) ? bin2hex($val): $val;
}

// UTF-8: basic tests
var_dump(_bin2hex(htmlentities("\xc1\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xc2\x80", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xc2\x00", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xc2\xc0", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xce\x91", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xce\xb1", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xdf\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xe0\xa0\x80", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xe0\x9f\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xe0\x9f\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xe0\x1f\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xe0\x9f\x3f", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xe0\x1f\x3f", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xe2\x99\xa5", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xef\xbf\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xef\xff\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xef\xbf\xff", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf0\x8f\xbf\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf0\x90\x80\x80", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf7\xbf\xbf\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf7\x3f\xbf\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf7\xbf\x3f\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf7\xbf\xbf\x3f", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf7\xff\xbf\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf7\xbf\xff\xbf", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf7\xbf\xbf\xff", ENT_QUOTES, "UTF-8")));
var_dump(_bin2hex(htmlentities("\xf8\x88\x80\x80\x80", ENT_QUOTES, "UTF-8")));

echo "--\n";
// UTF-8: alternative (invalid) UTF-8 sequence / surrogate pairs
var_dump(_bin2hex(htmlspecialchars("\xc0\xa6", ENT_QUOTES, 'UTF-8')));
var_dump(_bin2hex(htmlspecialchars("\xe0\x80\xa6", ENT_QUOTES, 'UTF-8')));
var_dump(_bin2hex(htmlspecialchars("\xf0\x80\x80\xa6", ENT_QUOTES, 'UTF-8')));
var_dump(_bin2hex(htmlspecialchars("\xec\xbf\xbf", ENT_QUOTES, 'UTF-8')));
var_dump(_bin2hex(htmlspecialchars("\xed\xa0\x80", ENT_QUOTES, 'UTF-8')));
var_dump(_bin2hex(htmlspecialchars("\xed\xbf\xbf", ENT_QUOTES, 'UTF-8')));
var_dump(_bin2hex(htmlspecialchars("\xee\x80\x80", ENT_QUOTES, 'UTF-8')));

// Shift_JIS: non-lead byte >= 0x80
var_dump(_bin2hex(htmlspecialchars("\x80", ENT_QUOTES, 'Shift_JIS')));
foreach (array_map('chr', range(0xa0, 0xdf)) as $c) {
    var_dump(_bin2hex(htmlspecialchars($c, ENT_QUOTES, 'Shift_JIS')));
}
var_dump(_bin2hex(htmlspecialchars("\xfd", ENT_QUOTES, 'Shift_JIS')));
var_dump(_bin2hex(htmlspecialchars("\xfe", ENT_QUOTES, 'Shift_JIS')));
var_dump(_bin2hex(htmlspecialchars("\xff", ENT_QUOTES, 'Shift_JIS')));

echo "--\n";
// Shift_JIS: incomplete / invalid multibyte sequences
foreach (array_map('chr', array_merge(range(0x81, 0x9f), range(0xe0, 0xfc))) as $c) {
    var_dump(_bin2hex(htmlspecialchars("$c", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\x3f", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\x40", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\x7e", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\x7f", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\x80", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\xfc", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\xfd", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\xfe", ENT_QUOTES, 'Shift_JIS')));
    var_dump(_bin2hex(htmlspecialchars("$c\xff", ENT_QUOTES, 'Shift_JIS')));
}

echo "--\n";
// EUC-JP: non-lead byte >= 0x80
foreach (array_map('chr', array_merge(range(0x80, 0x8d), range(0x90, 0x9f))) as $c) {
    var_dump(_bin2hex(htmlspecialchars($c, ENT_QUOTES, 'EUC-JP')));
}
var_dump(_bin2hex(htmlspecialchars("\xff", ENT_QUOTES, 'EUC-JP')));

// EUC-JP: control codes that are virtually lead bytes
var_dump(_bin2hex(htmlspecialchars("\x8e", ENT_QUOTES, 'EUC-JP')));
var_dump(_bin2hex(htmlspecialchars("\x8f", ENT_QUOTES, 'EUC-JP')));
var_dump(_bin2hex(htmlspecialchars("\x8e\xa1", ENT_QUOTES, 'EUC-JP')));
var_dump(_bin2hex(htmlspecialchars("\x8f\xa1", ENT_QUOTES, 'EUC-JP')));
var_dump(_bin2hex(htmlspecialchars("\x8e\xa1\xa3", ENT_QUOTES, 'EUC-JP')));
var_dump(_bin2hex(htmlspecialchars("\x8f\xa1\xa3", ENT_QUOTES, 'EUC-JP')));

echo "--\n";
// EUC-JP: incomplete / invalid multibyte sequences
foreach (array_map('chr', array_merge(range(0xa1, 0xfe))) as $c) {
    var_dump(_bin2hex(htmlspecialchars("$c", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("$c\x26", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("$c\x80", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("$c\xa0", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("$c\xa1", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("$c\xfe", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("$c\xff", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8e$c", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8e$c\x26", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8e$c\x80", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8e$c\xa0", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8e$c\xa1", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8e$c\xfe", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8e$c\xff", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8f$c", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8f$c\x26", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8f$c\x80", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8f$c\xa0", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8f$c\xa1", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8f$c\xfe", ENT_QUOTES, 'EUC-JP')));
    var_dump(_bin2hex(htmlspecialchars("\x8f$c\xff", ENT_QUOTES, 'EUC-JP')));
}

echo "--\n";
// BIG5: non-lead byte >= 0x80
var_dump(_bin2hex(htmlspecialchars("\x80", ENT_QUOTES, 'BIG5')));
var_dump(_bin2hex(htmlspecialchars("\xff", ENT_QUOTES, 'BIG5')));

echo "--\n";
// BIG5: incomplete / invalid multibyte sequences
foreach (array_map('chr', range(0x81, 0xfe)) as $c) {
    var_dump(_bin2hex(htmlspecialchars("$c", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\x3f", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\x40", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\x7e", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\x7f", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\x80", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\xa0", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\xa1", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\xfe", ENT_QUOTES, 'BIG5')));
    var_dump(_bin2hex(htmlspecialchars("$c\xff", ENT_QUOTES, 'BIG5')));
}
?>
--EXPECT--
string(0) ""
string(4) "c280"
string(0) ""
string(0) ""
string(14) "26416c7068613b"
string(14) "26616c7068613b"
string(4) "dfbf"
string(6) "e0a080"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(16) "266865617274733b"
string(6) "efbfbf"
string(0) ""
string(0) ""
string(0) ""
string(8) "f0908080"
string(8) "f7bfbfbf"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
--
string(0) ""
string(0) ""
string(0) ""
string(6) "ecbfbf"
string(0) ""
string(0) ""
string(6) "ee8080"
string(2) "80"
string(2) "a0"
string(2) "a1"
string(2) "a2"
string(2) "a3"
string(2) "a4"
string(2) "a5"
string(2) "a6"
string(2) "a7"
string(2) "a8"
string(2) "a9"
string(2) "aa"
string(2) "ab"
string(2) "ac"
string(2) "ad"
string(2) "ae"
string(2) "af"
string(2) "b0"
string(2) "b1"
string(2) "b2"
string(2) "b3"
string(2) "b4"
string(2) "b5"
string(2) "b6"
string(2) "b7"
string(2) "b8"
string(2) "b9"
string(2) "ba"
string(2) "bb"
string(2) "bc"
string(2) "bd"
string(2) "be"
string(2) "bf"
string(2) "c0"
string(2) "c1"
string(2) "c2"
string(2) "c3"
string(2) "c4"
string(2) "c5"
string(2) "c6"
string(2) "c7"
string(2) "c8"
string(2) "c9"
string(2) "ca"
string(2) "cb"
string(2) "cc"
string(2) "cd"
string(2) "ce"
string(2) "cf"
string(2) "d0"
string(2) "d1"
string(2) "d2"
string(2) "d3"
string(2) "d4"
string(2) "d5"
string(2) "d6"
string(2) "d7"
string(2) "d8"
string(2) "d9"
string(2) "da"
string(2) "db"
string(2) "dc"
string(2) "dd"
string(2) "de"
string(2) "df"
string(2) "fd"
string(2) "fe"
string(2) "ff"
--
string(0) ""
string(0) ""
string(4) "8140"
string(4) "817e"
string(0) ""
string(4) "8180"
string(4) "81fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8240"
string(4) "827e"
string(0) ""
string(4) "8280"
string(4) "82fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8340"
string(4) "837e"
string(0) ""
string(4) "8380"
string(4) "83fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8440"
string(4) "847e"
string(0) ""
string(4) "8480"
string(4) "84fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8540"
string(4) "857e"
string(0) ""
string(4) "8580"
string(4) "85fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8640"
string(4) "867e"
string(0) ""
string(4) "8680"
string(4) "86fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8740"
string(4) "877e"
string(0) ""
string(4) "8780"
string(4) "87fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8840"
string(4) "887e"
string(0) ""
string(4) "8880"
string(4) "88fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8940"
string(4) "897e"
string(0) ""
string(4) "8980"
string(4) "89fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8a40"
string(4) "8a7e"
string(0) ""
string(4) "8a80"
string(4) "8afc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8b40"
string(4) "8b7e"
string(0) ""
string(4) "8b80"
string(4) "8bfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8c40"
string(4) "8c7e"
string(0) ""
string(4) "8c80"
string(4) "8cfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8d40"
string(4) "8d7e"
string(0) ""
string(4) "8d80"
string(4) "8dfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8e40"
string(4) "8e7e"
string(0) ""
string(4) "8e80"
string(4) "8efc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "8f40"
string(4) "8f7e"
string(0) ""
string(4) "8f80"
string(4) "8ffc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9040"
string(4) "907e"
string(0) ""
string(4) "9080"
string(4) "90fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9140"
string(4) "917e"
string(0) ""
string(4) "9180"
string(4) "91fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9240"
string(4) "927e"
string(0) ""
string(4) "9280"
string(4) "92fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9340"
string(4) "937e"
string(0) ""
string(4) "9380"
string(4) "93fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9440"
string(4) "947e"
string(0) ""
string(4) "9480"
string(4) "94fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9540"
string(4) "957e"
string(0) ""
string(4) "9580"
string(4) "95fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9640"
string(4) "967e"
string(0) ""
string(4) "9680"
string(4) "96fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9740"
string(4) "977e"
string(0) ""
string(4) "9780"
string(4) "97fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9840"
string(4) "987e"
string(0) ""
string(4) "9880"
string(4) "98fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9940"
string(4) "997e"
string(0) ""
string(4) "9980"
string(4) "99fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9a40"
string(4) "9a7e"
string(0) ""
string(4) "9a80"
string(4) "9afc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9b40"
string(4) "9b7e"
string(0) ""
string(4) "9b80"
string(4) "9bfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9c40"
string(4) "9c7e"
string(0) ""
string(4) "9c80"
string(4) "9cfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9d40"
string(4) "9d7e"
string(0) ""
string(4) "9d80"
string(4) "9dfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9e40"
string(4) "9e7e"
string(0) ""
string(4) "9e80"
string(4) "9efc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "9f40"
string(4) "9f7e"
string(0) ""
string(4) "9f80"
string(4) "9ffc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e040"
string(4) "e07e"
string(0) ""
string(4) "e080"
string(4) "e0fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e140"
string(4) "e17e"
string(0) ""
string(4) "e180"
string(4) "e1fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e240"
string(4) "e27e"
string(0) ""
string(4) "e280"
string(4) "e2fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e340"
string(4) "e37e"
string(0) ""
string(4) "e380"
string(4) "e3fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e440"
string(4) "e47e"
string(0) ""
string(4) "e480"
string(4) "e4fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e540"
string(4) "e57e"
string(0) ""
string(4) "e580"
string(4) "e5fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e640"
string(4) "e67e"
string(0) ""
string(4) "e680"
string(4) "e6fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e740"
string(4) "e77e"
string(0) ""
string(4) "e780"
string(4) "e7fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e840"
string(4) "e87e"
string(0) ""
string(4) "e880"
string(4) "e8fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e940"
string(4) "e97e"
string(0) ""
string(4) "e980"
string(4) "e9fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "ea40"
string(4) "ea7e"
string(0) ""
string(4) "ea80"
string(4) "eafc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "eb40"
string(4) "eb7e"
string(0) ""
string(4) "eb80"
string(4) "ebfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "ec40"
string(4) "ec7e"
string(0) ""
string(4) "ec80"
string(4) "ecfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "ed40"
string(4) "ed7e"
string(0) ""
string(4) "ed80"
string(4) "edfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "ee40"
string(4) "ee7e"
string(0) ""
string(4) "ee80"
string(4) "eefc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "ef40"
string(4) "ef7e"
string(0) ""
string(4) "ef80"
string(4) "effc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f040"
string(4) "f07e"
string(0) ""
string(4) "f080"
string(4) "f0fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f140"
string(4) "f17e"
string(0) ""
string(4) "f180"
string(4) "f1fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f240"
string(4) "f27e"
string(0) ""
string(4) "f280"
string(4) "f2fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f340"
string(4) "f37e"
string(0) ""
string(4) "f380"
string(4) "f3fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f440"
string(4) "f47e"
string(0) ""
string(4) "f480"
string(4) "f4fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f540"
string(4) "f57e"
string(0) ""
string(4) "f580"
string(4) "f5fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f640"
string(4) "f67e"
string(0) ""
string(4) "f680"
string(4) "f6fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f740"
string(4) "f77e"
string(0) ""
string(4) "f780"
string(4) "f7fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f840"
string(4) "f87e"
string(0) ""
string(4) "f880"
string(4) "f8fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f940"
string(4) "f97e"
string(0) ""
string(4) "f980"
string(4) "f9fc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "fa40"
string(4) "fa7e"
string(0) ""
string(4) "fa80"
string(4) "fafc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "fb40"
string(4) "fb7e"
string(0) ""
string(4) "fb80"
string(4) "fbfc"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "fc40"
string(4) "fc7e"
string(0) ""
string(4) "fc80"
string(4) "fcfc"
string(0) ""
string(0) ""
string(0) ""
--
string(2) "80"
string(2) "81"
string(2) "82"
string(2) "83"
string(2) "84"
string(2) "85"
string(2) "86"
string(2) "87"
string(2) "88"
string(2) "89"
string(2) "8a"
string(2) "8b"
string(2) "8c"
string(2) "8d"
string(2) "90"
string(2) "91"
string(2) "92"
string(2) "93"
string(2) "94"
string(2) "95"
string(2) "96"
string(2) "97"
string(2) "98"
string(2) "99"
string(2) "9a"
string(2) "9b"
string(2) "9c"
string(2) "9d"
string(2) "9e"
string(2) "9f"
string(2) "ff"
string(0) ""
string(0) ""
string(4) "8ea1"
string(0) ""
string(0) ""
string(6) "8fa1a3"
--
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a1a1"
string(4) "a1fe"
string(0) ""
string(4) "8ea1"
string(14) "8ea126616d703b"
string(6) "8ea180"
string(6) "8ea1a0"
string(0) ""
string(0) ""
string(6) "8ea1ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa1a1"
string(6) "8fa1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a2a1"
string(4) "a2fe"
string(0) ""
string(4) "8ea2"
string(14) "8ea226616d703b"
string(6) "8ea280"
string(6) "8ea2a0"
string(0) ""
string(0) ""
string(6) "8ea2ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa2a1"
string(6) "8fa2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a3a1"
string(4) "a3fe"
string(0) ""
string(4) "8ea3"
string(14) "8ea326616d703b"
string(6) "8ea380"
string(6) "8ea3a0"
string(0) ""
string(0) ""
string(6) "8ea3ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa3a1"
string(6) "8fa3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a4a1"
string(4) "a4fe"
string(0) ""
string(4) "8ea4"
string(14) "8ea426616d703b"
string(6) "8ea480"
string(6) "8ea4a0"
string(0) ""
string(0) ""
string(6) "8ea4ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa4a1"
string(6) "8fa4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a5a1"
string(4) "a5fe"
string(0) ""
string(4) "8ea5"
string(14) "8ea526616d703b"
string(6) "8ea580"
string(6) "8ea5a0"
string(0) ""
string(0) ""
string(6) "8ea5ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa5a1"
string(6) "8fa5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a6a1"
string(4) "a6fe"
string(0) ""
string(4) "8ea6"
string(14) "8ea626616d703b"
string(6) "8ea680"
string(6) "8ea6a0"
string(0) ""
string(0) ""
string(6) "8ea6ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa6a1"
string(6) "8fa6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a7a1"
string(4) "a7fe"
string(0) ""
string(4) "8ea7"
string(14) "8ea726616d703b"
string(6) "8ea780"
string(6) "8ea7a0"
string(0) ""
string(0) ""
string(6) "8ea7ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa7a1"
string(6) "8fa7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a8a1"
string(4) "a8fe"
string(0) ""
string(4) "8ea8"
string(14) "8ea826616d703b"
string(6) "8ea880"
string(6) "8ea8a0"
string(0) ""
string(0) ""
string(6) "8ea8ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa8a1"
string(6) "8fa8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "a9a1"
string(4) "a9fe"
string(0) ""
string(4) "8ea9"
string(14) "8ea926616d703b"
string(6) "8ea980"
string(6) "8ea9a0"
string(0) ""
string(0) ""
string(6) "8ea9ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fa9a1"
string(6) "8fa9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "aaa1"
string(4) "aafe"
string(0) ""
string(4) "8eaa"
string(14) "8eaa26616d703b"
string(6) "8eaa80"
string(6) "8eaaa0"
string(0) ""
string(0) ""
string(6) "8eaaff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8faaa1"
string(6) "8faafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "aba1"
string(4) "abfe"
string(0) ""
string(4) "8eab"
string(14) "8eab26616d703b"
string(6) "8eab80"
string(6) "8eaba0"
string(0) ""
string(0) ""
string(6) "8eabff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8faba1"
string(6) "8fabfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "aca1"
string(4) "acfe"
string(0) ""
string(4) "8eac"
string(14) "8eac26616d703b"
string(6) "8eac80"
string(6) "8eaca0"
string(0) ""
string(0) ""
string(6) "8eacff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8faca1"
string(6) "8facfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "ada1"
string(4) "adfe"
string(0) ""
string(4) "8ead"
string(14) "8ead26616d703b"
string(6) "8ead80"
string(6) "8eada0"
string(0) ""
string(0) ""
string(6) "8eadff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fada1"
string(6) "8fadfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "aea1"
string(4) "aefe"
string(0) ""
string(4) "8eae"
string(14) "8eae26616d703b"
string(6) "8eae80"
string(6) "8eaea0"
string(0) ""
string(0) ""
string(6) "8eaeff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8faea1"
string(6) "8faefe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "afa1"
string(4) "affe"
string(0) ""
string(4) "8eaf"
string(14) "8eaf26616d703b"
string(6) "8eaf80"
string(6) "8eafa0"
string(0) ""
string(0) ""
string(6) "8eafff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fafa1"
string(6) "8faffe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b0a1"
string(4) "b0fe"
string(0) ""
string(4) "8eb0"
string(14) "8eb026616d703b"
string(6) "8eb080"
string(6) "8eb0a0"
string(0) ""
string(0) ""
string(6) "8eb0ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb0a1"
string(6) "8fb0fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b1a1"
string(4) "b1fe"
string(0) ""
string(4) "8eb1"
string(14) "8eb126616d703b"
string(6) "8eb180"
string(6) "8eb1a0"
string(0) ""
string(0) ""
string(6) "8eb1ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb1a1"
string(6) "8fb1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b2a1"
string(4) "b2fe"
string(0) ""
string(4) "8eb2"
string(14) "8eb226616d703b"
string(6) "8eb280"
string(6) "8eb2a0"
string(0) ""
string(0) ""
string(6) "8eb2ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb2a1"
string(6) "8fb2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b3a1"
string(4) "b3fe"
string(0) ""
string(4) "8eb3"
string(14) "8eb326616d703b"
string(6) "8eb380"
string(6) "8eb3a0"
string(0) ""
string(0) ""
string(6) "8eb3ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb3a1"
string(6) "8fb3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b4a1"
string(4) "b4fe"
string(0) ""
string(4) "8eb4"
string(14) "8eb426616d703b"
string(6) "8eb480"
string(6) "8eb4a0"
string(0) ""
string(0) ""
string(6) "8eb4ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb4a1"
string(6) "8fb4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b5a1"
string(4) "b5fe"
string(0) ""
string(4) "8eb5"
string(14) "8eb526616d703b"
string(6) "8eb580"
string(6) "8eb5a0"
string(0) ""
string(0) ""
string(6) "8eb5ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb5a1"
string(6) "8fb5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b6a1"
string(4) "b6fe"
string(0) ""
string(4) "8eb6"
string(14) "8eb626616d703b"
string(6) "8eb680"
string(6) "8eb6a0"
string(0) ""
string(0) ""
string(6) "8eb6ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb6a1"
string(6) "8fb6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b7a1"
string(4) "b7fe"
string(0) ""
string(4) "8eb7"
string(14) "8eb726616d703b"
string(6) "8eb780"
string(6) "8eb7a0"
string(0) ""
string(0) ""
string(6) "8eb7ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb7a1"
string(6) "8fb7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b8a1"
string(4) "b8fe"
string(0) ""
string(4) "8eb8"
string(14) "8eb826616d703b"
string(6) "8eb880"
string(6) "8eb8a0"
string(0) ""
string(0) ""
string(6) "8eb8ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb8a1"
string(6) "8fb8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "b9a1"
string(4) "b9fe"
string(0) ""
string(4) "8eb9"
string(14) "8eb926616d703b"
string(6) "8eb980"
string(6) "8eb9a0"
string(0) ""
string(0) ""
string(6) "8eb9ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fb9a1"
string(6) "8fb9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "baa1"
string(4) "bafe"
string(0) ""
string(4) "8eba"
string(14) "8eba26616d703b"
string(6) "8eba80"
string(6) "8ebaa0"
string(0) ""
string(0) ""
string(6) "8ebaff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fbaa1"
string(6) "8fbafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "bba1"
string(4) "bbfe"
string(0) ""
string(4) "8ebb"
string(14) "8ebb26616d703b"
string(6) "8ebb80"
string(6) "8ebba0"
string(0) ""
string(0) ""
string(6) "8ebbff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fbba1"
string(6) "8fbbfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "bca1"
string(4) "bcfe"
string(0) ""
string(4) "8ebc"
string(14) "8ebc26616d703b"
string(6) "8ebc80"
string(6) "8ebca0"
string(0) ""
string(0) ""
string(6) "8ebcff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fbca1"
string(6) "8fbcfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "bda1"
string(4) "bdfe"
string(0) ""
string(4) "8ebd"
string(14) "8ebd26616d703b"
string(6) "8ebd80"
string(6) "8ebda0"
string(0) ""
string(0) ""
string(6) "8ebdff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fbda1"
string(6) "8fbdfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "bea1"
string(4) "befe"
string(0) ""
string(4) "8ebe"
string(14) "8ebe26616d703b"
string(6) "8ebe80"
string(6) "8ebea0"
string(0) ""
string(0) ""
string(6) "8ebeff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fbea1"
string(6) "8fbefe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "bfa1"
string(4) "bffe"
string(0) ""
string(4) "8ebf"
string(14) "8ebf26616d703b"
string(6) "8ebf80"
string(6) "8ebfa0"
string(0) ""
string(0) ""
string(6) "8ebfff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fbfa1"
string(6) "8fbffe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c0a1"
string(4) "c0fe"
string(0) ""
string(4) "8ec0"
string(14) "8ec026616d703b"
string(6) "8ec080"
string(6) "8ec0a0"
string(0) ""
string(0) ""
string(6) "8ec0ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc0a1"
string(6) "8fc0fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c1a1"
string(4) "c1fe"
string(0) ""
string(4) "8ec1"
string(14) "8ec126616d703b"
string(6) "8ec180"
string(6) "8ec1a0"
string(0) ""
string(0) ""
string(6) "8ec1ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc1a1"
string(6) "8fc1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c2a1"
string(4) "c2fe"
string(0) ""
string(4) "8ec2"
string(14) "8ec226616d703b"
string(6) "8ec280"
string(6) "8ec2a0"
string(0) ""
string(0) ""
string(6) "8ec2ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc2a1"
string(6) "8fc2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c3a1"
string(4) "c3fe"
string(0) ""
string(4) "8ec3"
string(14) "8ec326616d703b"
string(6) "8ec380"
string(6) "8ec3a0"
string(0) ""
string(0) ""
string(6) "8ec3ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc3a1"
string(6) "8fc3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c4a1"
string(4) "c4fe"
string(0) ""
string(4) "8ec4"
string(14) "8ec426616d703b"
string(6) "8ec480"
string(6) "8ec4a0"
string(0) ""
string(0) ""
string(6) "8ec4ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc4a1"
string(6) "8fc4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c5a1"
string(4) "c5fe"
string(0) ""
string(4) "8ec5"
string(14) "8ec526616d703b"
string(6) "8ec580"
string(6) "8ec5a0"
string(0) ""
string(0) ""
string(6) "8ec5ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc5a1"
string(6) "8fc5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c6a1"
string(4) "c6fe"
string(0) ""
string(4) "8ec6"
string(14) "8ec626616d703b"
string(6) "8ec680"
string(6) "8ec6a0"
string(0) ""
string(0) ""
string(6) "8ec6ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc6a1"
string(6) "8fc6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c7a1"
string(4) "c7fe"
string(0) ""
string(4) "8ec7"
string(14) "8ec726616d703b"
string(6) "8ec780"
string(6) "8ec7a0"
string(0) ""
string(0) ""
string(6) "8ec7ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc7a1"
string(6) "8fc7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c8a1"
string(4) "c8fe"
string(0) ""
string(4) "8ec8"
string(14) "8ec826616d703b"
string(6) "8ec880"
string(6) "8ec8a0"
string(0) ""
string(0) ""
string(6) "8ec8ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc8a1"
string(6) "8fc8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "c9a1"
string(4) "c9fe"
string(0) ""
string(4) "8ec9"
string(14) "8ec926616d703b"
string(6) "8ec980"
string(6) "8ec9a0"
string(0) ""
string(0) ""
string(6) "8ec9ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fc9a1"
string(6) "8fc9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "caa1"
string(4) "cafe"
string(0) ""
string(4) "8eca"
string(14) "8eca26616d703b"
string(6) "8eca80"
string(6) "8ecaa0"
string(0) ""
string(0) ""
string(6) "8ecaff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fcaa1"
string(6) "8fcafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "cba1"
string(4) "cbfe"
string(0) ""
string(4) "8ecb"
string(14) "8ecb26616d703b"
string(6) "8ecb80"
string(6) "8ecba0"
string(0) ""
string(0) ""
string(6) "8ecbff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fcba1"
string(6) "8fcbfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "cca1"
string(4) "ccfe"
string(0) ""
string(4) "8ecc"
string(14) "8ecc26616d703b"
string(6) "8ecc80"
string(6) "8ecca0"
string(0) ""
string(0) ""
string(6) "8eccff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fcca1"
string(6) "8fccfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "cda1"
string(4) "cdfe"
string(0) ""
string(4) "8ecd"
string(14) "8ecd26616d703b"
string(6) "8ecd80"
string(6) "8ecda0"
string(0) ""
string(0) ""
string(6) "8ecdff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fcda1"
string(6) "8fcdfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "cea1"
string(4) "cefe"
string(0) ""
string(4) "8ece"
string(14) "8ece26616d703b"
string(6) "8ece80"
string(6) "8ecea0"
string(0) ""
string(0) ""
string(6) "8eceff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fcea1"
string(6) "8fcefe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "cfa1"
string(4) "cffe"
string(0) ""
string(4) "8ecf"
string(14) "8ecf26616d703b"
string(6) "8ecf80"
string(6) "8ecfa0"
string(0) ""
string(0) ""
string(6) "8ecfff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fcfa1"
string(6) "8fcffe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d0a1"
string(4) "d0fe"
string(0) ""
string(4) "8ed0"
string(14) "8ed026616d703b"
string(6) "8ed080"
string(6) "8ed0a0"
string(0) ""
string(0) ""
string(6) "8ed0ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd0a1"
string(6) "8fd0fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d1a1"
string(4) "d1fe"
string(0) ""
string(4) "8ed1"
string(14) "8ed126616d703b"
string(6) "8ed180"
string(6) "8ed1a0"
string(0) ""
string(0) ""
string(6) "8ed1ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd1a1"
string(6) "8fd1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d2a1"
string(4) "d2fe"
string(0) ""
string(4) "8ed2"
string(14) "8ed226616d703b"
string(6) "8ed280"
string(6) "8ed2a0"
string(0) ""
string(0) ""
string(6) "8ed2ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd2a1"
string(6) "8fd2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d3a1"
string(4) "d3fe"
string(0) ""
string(4) "8ed3"
string(14) "8ed326616d703b"
string(6) "8ed380"
string(6) "8ed3a0"
string(0) ""
string(0) ""
string(6) "8ed3ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd3a1"
string(6) "8fd3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d4a1"
string(4) "d4fe"
string(0) ""
string(4) "8ed4"
string(14) "8ed426616d703b"
string(6) "8ed480"
string(6) "8ed4a0"
string(0) ""
string(0) ""
string(6) "8ed4ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd4a1"
string(6) "8fd4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d5a1"
string(4) "d5fe"
string(0) ""
string(4) "8ed5"
string(14) "8ed526616d703b"
string(6) "8ed580"
string(6) "8ed5a0"
string(0) ""
string(0) ""
string(6) "8ed5ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd5a1"
string(6) "8fd5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d6a1"
string(4) "d6fe"
string(0) ""
string(4) "8ed6"
string(14) "8ed626616d703b"
string(6) "8ed680"
string(6) "8ed6a0"
string(0) ""
string(0) ""
string(6) "8ed6ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd6a1"
string(6) "8fd6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d7a1"
string(4) "d7fe"
string(0) ""
string(4) "8ed7"
string(14) "8ed726616d703b"
string(6) "8ed780"
string(6) "8ed7a0"
string(0) ""
string(0) ""
string(6) "8ed7ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd7a1"
string(6) "8fd7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d8a1"
string(4) "d8fe"
string(0) ""
string(4) "8ed8"
string(14) "8ed826616d703b"
string(6) "8ed880"
string(6) "8ed8a0"
string(0) ""
string(0) ""
string(6) "8ed8ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd8a1"
string(6) "8fd8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "d9a1"
string(4) "d9fe"
string(0) ""
string(4) "8ed9"
string(14) "8ed926616d703b"
string(6) "8ed980"
string(6) "8ed9a0"
string(0) ""
string(0) ""
string(6) "8ed9ff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fd9a1"
string(6) "8fd9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "daa1"
string(4) "dafe"
string(0) ""
string(4) "8eda"
string(14) "8eda26616d703b"
string(6) "8eda80"
string(6) "8edaa0"
string(0) ""
string(0) ""
string(6) "8edaff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fdaa1"
string(6) "8fdafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "dba1"
string(4) "dbfe"
string(0) ""
string(4) "8edb"
string(14) "8edb26616d703b"
string(6) "8edb80"
string(6) "8edba0"
string(0) ""
string(0) ""
string(6) "8edbff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fdba1"
string(6) "8fdbfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "dca1"
string(4) "dcfe"
string(0) ""
string(4) "8edc"
string(14) "8edc26616d703b"
string(6) "8edc80"
string(6) "8edca0"
string(0) ""
string(0) ""
string(6) "8edcff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fdca1"
string(6) "8fdcfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "dda1"
string(4) "ddfe"
string(0) ""
string(4) "8edd"
string(14) "8edd26616d703b"
string(6) "8edd80"
string(6) "8edda0"
string(0) ""
string(0) ""
string(6) "8eddff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fdda1"
string(6) "8fddfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "dea1"
string(4) "defe"
string(0) ""
string(4) "8ede"
string(14) "8ede26616d703b"
string(6) "8ede80"
string(6) "8edea0"
string(0) ""
string(0) ""
string(6) "8edeff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fdea1"
string(6) "8fdefe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "dfa1"
string(4) "dffe"
string(0) ""
string(4) "8edf"
string(14) "8edf26616d703b"
string(6) "8edf80"
string(6) "8edfa0"
string(0) ""
string(0) ""
string(6) "8edfff"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fdfa1"
string(6) "8fdffe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e0a1"
string(4) "e0fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe0a1"
string(6) "8fe0fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e1a1"
string(4) "e1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe1a1"
string(6) "8fe1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e2a1"
string(4) "e2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe2a1"
string(6) "8fe2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e3a1"
string(4) "e3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe3a1"
string(6) "8fe3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e4a1"
string(4) "e4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe4a1"
string(6) "8fe4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e5a1"
string(4) "e5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe5a1"
string(6) "8fe5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e6a1"
string(4) "e6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe6a1"
string(6) "8fe6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e7a1"
string(4) "e7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe7a1"
string(6) "8fe7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e8a1"
string(4) "e8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe8a1"
string(6) "8fe8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "e9a1"
string(4) "e9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fe9a1"
string(6) "8fe9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "eaa1"
string(4) "eafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8feaa1"
string(6) "8feafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "eba1"
string(4) "ebfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8feba1"
string(6) "8febfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "eca1"
string(4) "ecfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8feca1"
string(6) "8fecfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "eda1"
string(4) "edfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8feda1"
string(6) "8fedfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "eea1"
string(4) "eefe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8feea1"
string(6) "8feefe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "efa1"
string(4) "effe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8fefa1"
string(6) "8feffe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f0a1"
string(4) "f0fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff0a1"
string(6) "8ff0fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f1a1"
string(4) "f1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff1a1"
string(6) "8ff1fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f2a1"
string(4) "f2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff2a1"
string(6) "8ff2fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f3a1"
string(4) "f3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff3a1"
string(6) "8ff3fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f4a1"
string(4) "f4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff4a1"
string(6) "8ff4fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f5a1"
string(4) "f5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff5a1"
string(6) "8ff5fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f6a1"
string(4) "f6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff6a1"
string(6) "8ff6fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f7a1"
string(4) "f7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff7a1"
string(6) "8ff7fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f8a1"
string(4) "f8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff8a1"
string(6) "8ff8fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "f9a1"
string(4) "f9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ff9a1"
string(6) "8ff9fe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "faa1"
string(4) "fafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ffaa1"
string(6) "8ffafe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "fba1"
string(4) "fbfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ffba1"
string(6) "8ffbfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "fca1"
string(4) "fcfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ffca1"
string(6) "8ffcfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "fda1"
string(4) "fdfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ffda1"
string(6) "8ffdfe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(4) "fea1"
string(4) "fefe"
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(0) ""
string(6) "8ffea1"
string(6) "8ffefe"
string(0) ""
--
string(2) "80"
string(2) "ff"
--
string(0) ""
string(0) ""
string(4) "8140"
string(4) "817e"
string(0) ""
string(0) ""
string(0) ""
string(4) "81a1"
string(4) "81fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8240"
string(4) "827e"
string(0) ""
string(0) ""
string(0) ""
string(4) "82a1"
string(4) "82fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8340"
string(4) "837e"
string(0) ""
string(0) ""
string(0) ""
string(4) "83a1"
string(4) "83fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8440"
string(4) "847e"
string(0) ""
string(0) ""
string(0) ""
string(4) "84a1"
string(4) "84fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8540"
string(4) "857e"
string(0) ""
string(0) ""
string(0) ""
string(4) "85a1"
string(4) "85fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8640"
string(4) "867e"
string(0) ""
string(0) ""
string(0) ""
string(4) "86a1"
string(4) "86fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8740"
string(4) "877e"
string(0) ""
string(0) ""
string(0) ""
string(4) "87a1"
string(4) "87fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8840"
string(4) "887e"
string(0) ""
string(0) ""
string(0) ""
string(4) "88a1"
string(4) "88fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8940"
string(4) "897e"
string(0) ""
string(0) ""
string(0) ""
string(4) "89a1"
string(4) "89fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8a40"
string(4) "8a7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "8aa1"
string(4) "8afe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8b40"
string(4) "8b7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "8ba1"
string(4) "8bfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8c40"
string(4) "8c7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "8ca1"
string(4) "8cfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8d40"
string(4) "8d7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "8da1"
string(4) "8dfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8e40"
string(4) "8e7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "8ea1"
string(4) "8efe"
string(0) ""
string(0) ""
string(0) ""
string(4) "8f40"
string(4) "8f7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "8fa1"
string(4) "8ffe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9040"
string(4) "907e"
string(0) ""
string(0) ""
string(0) ""
string(4) "90a1"
string(4) "90fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9140"
string(4) "917e"
string(0) ""
string(0) ""
string(0) ""
string(4) "91a1"
string(4) "91fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9240"
string(4) "927e"
string(0) ""
string(0) ""
string(0) ""
string(4) "92a1"
string(4) "92fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9340"
string(4) "937e"
string(0) ""
string(0) ""
string(0) ""
string(4) "93a1"
string(4) "93fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9440"
string(4) "947e"
string(0) ""
string(0) ""
string(0) ""
string(4) "94a1"
string(4) "94fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9540"
string(4) "957e"
string(0) ""
string(0) ""
string(0) ""
string(4) "95a1"
string(4) "95fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9640"
string(4) "967e"
string(0) ""
string(0) ""
string(0) ""
string(4) "96a1"
string(4) "96fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9740"
string(4) "977e"
string(0) ""
string(0) ""
string(0) ""
string(4) "97a1"
string(4) "97fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9840"
string(4) "987e"
string(0) ""
string(0) ""
string(0) ""
string(4) "98a1"
string(4) "98fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9940"
string(4) "997e"
string(0) ""
string(0) ""
string(0) ""
string(4) "99a1"
string(4) "99fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9a40"
string(4) "9a7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "9aa1"
string(4) "9afe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9b40"
string(4) "9b7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "9ba1"
string(4) "9bfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9c40"
string(4) "9c7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "9ca1"
string(4) "9cfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9d40"
string(4) "9d7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "9da1"
string(4) "9dfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9e40"
string(4) "9e7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "9ea1"
string(4) "9efe"
string(0) ""
string(0) ""
string(0) ""
string(4) "9f40"
string(4) "9f7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "9fa1"
string(4) "9ffe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a040"
string(4) "a07e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a0a1"
string(4) "a0fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a140"
string(4) "a17e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a1a1"
string(4) "a1fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a240"
string(4) "a27e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a2a1"
string(4) "a2fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a340"
string(4) "a37e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a3a1"
string(4) "a3fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a440"
string(4) "a47e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a4a1"
string(4) "a4fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a540"
string(4) "a57e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a5a1"
string(4) "a5fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a640"
string(4) "a67e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a6a1"
string(4) "a6fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a740"
string(4) "a77e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a7a1"
string(4) "a7fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a840"
string(4) "a87e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a8a1"
string(4) "a8fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "a940"
string(4) "a97e"
string(0) ""
string(0) ""
string(0) ""
string(4) "a9a1"
string(4) "a9fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "aa40"
string(4) "aa7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "aaa1"
string(4) "aafe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ab40"
string(4) "ab7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "aba1"
string(4) "abfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ac40"
string(4) "ac7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "aca1"
string(4) "acfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ad40"
string(4) "ad7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "ada1"
string(4) "adfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ae40"
string(4) "ae7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "aea1"
string(4) "aefe"
string(0) ""
string(0) ""
string(0) ""
string(4) "af40"
string(4) "af7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "afa1"
string(4) "affe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b040"
string(4) "b07e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b0a1"
string(4) "b0fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b140"
string(4) "b17e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b1a1"
string(4) "b1fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b240"
string(4) "b27e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b2a1"
string(4) "b2fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b340"
string(4) "b37e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b3a1"
string(4) "b3fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b440"
string(4) "b47e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b4a1"
string(4) "b4fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b540"
string(4) "b57e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b5a1"
string(4) "b5fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b640"
string(4) "b67e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b6a1"
string(4) "b6fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b740"
string(4) "b77e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b7a1"
string(4) "b7fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b840"
string(4) "b87e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b8a1"
string(4) "b8fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "b940"
string(4) "b97e"
string(0) ""
string(0) ""
string(0) ""
string(4) "b9a1"
string(4) "b9fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ba40"
string(4) "ba7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "baa1"
string(4) "bafe"
string(0) ""
string(0) ""
string(0) ""
string(4) "bb40"
string(4) "bb7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "bba1"
string(4) "bbfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "bc40"
string(4) "bc7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "bca1"
string(4) "bcfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "bd40"
string(4) "bd7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "bda1"
string(4) "bdfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "be40"
string(4) "be7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "bea1"
string(4) "befe"
string(0) ""
string(0) ""
string(0) ""
string(4) "bf40"
string(4) "bf7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "bfa1"
string(4) "bffe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c040"
string(4) "c07e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c0a1"
string(4) "c0fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c140"
string(4) "c17e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c1a1"
string(4) "c1fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c240"
string(4) "c27e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c2a1"
string(4) "c2fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c340"
string(4) "c37e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c3a1"
string(4) "c3fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c440"
string(4) "c47e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c4a1"
string(4) "c4fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c540"
string(4) "c57e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c5a1"
string(4) "c5fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c640"
string(4) "c67e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c6a1"
string(4) "c6fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c740"
string(4) "c77e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c7a1"
string(4) "c7fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c840"
string(4) "c87e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c8a1"
string(4) "c8fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "c940"
string(4) "c97e"
string(0) ""
string(0) ""
string(0) ""
string(4) "c9a1"
string(4) "c9fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ca40"
string(4) "ca7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "caa1"
string(4) "cafe"
string(0) ""
string(0) ""
string(0) ""
string(4) "cb40"
string(4) "cb7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "cba1"
string(4) "cbfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "cc40"
string(4) "cc7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "cca1"
string(4) "ccfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "cd40"
string(4) "cd7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "cda1"
string(4) "cdfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ce40"
string(4) "ce7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "cea1"
string(4) "cefe"
string(0) ""
string(0) ""
string(0) ""
string(4) "cf40"
string(4) "cf7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "cfa1"
string(4) "cffe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d040"
string(4) "d07e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d0a1"
string(4) "d0fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d140"
string(4) "d17e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d1a1"
string(4) "d1fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d240"
string(4) "d27e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d2a1"
string(4) "d2fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d340"
string(4) "d37e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d3a1"
string(4) "d3fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d440"
string(4) "d47e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d4a1"
string(4) "d4fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d540"
string(4) "d57e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d5a1"
string(4) "d5fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d640"
string(4) "d67e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d6a1"
string(4) "d6fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d740"
string(4) "d77e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d7a1"
string(4) "d7fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d840"
string(4) "d87e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d8a1"
string(4) "d8fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "d940"
string(4) "d97e"
string(0) ""
string(0) ""
string(0) ""
string(4) "d9a1"
string(4) "d9fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "da40"
string(4) "da7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "daa1"
string(4) "dafe"
string(0) ""
string(0) ""
string(0) ""
string(4) "db40"
string(4) "db7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "dba1"
string(4) "dbfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "dc40"
string(4) "dc7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "dca1"
string(4) "dcfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "dd40"
string(4) "dd7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "dda1"
string(4) "ddfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "de40"
string(4) "de7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "dea1"
string(4) "defe"
string(0) ""
string(0) ""
string(0) ""
string(4) "df40"
string(4) "df7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "dfa1"
string(4) "dffe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e040"
string(4) "e07e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e0a1"
string(4) "e0fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e140"
string(4) "e17e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e1a1"
string(4) "e1fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e240"
string(4) "e27e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e2a1"
string(4) "e2fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e340"
string(4) "e37e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e3a1"
string(4) "e3fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e440"
string(4) "e47e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e4a1"
string(4) "e4fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e540"
string(4) "e57e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e5a1"
string(4) "e5fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e640"
string(4) "e67e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e6a1"
string(4) "e6fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e740"
string(4) "e77e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e7a1"
string(4) "e7fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e840"
string(4) "e87e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e8a1"
string(4) "e8fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "e940"
string(4) "e97e"
string(0) ""
string(0) ""
string(0) ""
string(4) "e9a1"
string(4) "e9fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ea40"
string(4) "ea7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "eaa1"
string(4) "eafe"
string(0) ""
string(0) ""
string(0) ""
string(4) "eb40"
string(4) "eb7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "eba1"
string(4) "ebfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ec40"
string(4) "ec7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "eca1"
string(4) "ecfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ed40"
string(4) "ed7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "eda1"
string(4) "edfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ee40"
string(4) "ee7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "eea1"
string(4) "eefe"
string(0) ""
string(0) ""
string(0) ""
string(4) "ef40"
string(4) "ef7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "efa1"
string(4) "effe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f040"
string(4) "f07e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f0a1"
string(4) "f0fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f140"
string(4) "f17e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f1a1"
string(4) "f1fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f240"
string(4) "f27e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f2a1"
string(4) "f2fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f340"
string(4) "f37e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f3a1"
string(4) "f3fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f440"
string(4) "f47e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f4a1"
string(4) "f4fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f540"
string(4) "f57e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f5a1"
string(4) "f5fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f640"
string(4) "f67e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f6a1"
string(4) "f6fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f740"
string(4) "f77e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f7a1"
string(4) "f7fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f840"
string(4) "f87e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f8a1"
string(4) "f8fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "f940"
string(4) "f97e"
string(0) ""
string(0) ""
string(0) ""
string(4) "f9a1"
string(4) "f9fe"
string(0) ""
string(0) ""
string(0) ""
string(4) "fa40"
string(4) "fa7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "faa1"
string(4) "fafe"
string(0) ""
string(0) ""
string(0) ""
string(4) "fb40"
string(4) "fb7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "fba1"
string(4) "fbfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "fc40"
string(4) "fc7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "fca1"
string(4) "fcfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "fd40"
string(4) "fd7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "fda1"
string(4) "fdfe"
string(0) ""
string(0) ""
string(0) ""
string(4) "fe40"
string(4) "fe7e"
string(0) ""
string(0) ""
string(0) ""
string(4) "fea1"
string(4) "fefe"
string(0) ""
