package com.jm.gen;

import java.util.ArrayList;
import java.util.List;

import com.jm.GenPattern;
import com.jm.JmPattern;
import com.jm.Menu2;
import com.jm.utility.AsyncTaskIF;
import com.jm.utility.Debug;

public class MainGen implements AsyncTaskIF {
	// エラーコード
	public static final int GEN_ERR_UNKNOWN = -1;
	public static final int GEN_ERR_MALLOC = -2;
	public static final int GEN_ERR_BUFFSIZE = -3;
	public static final int GEN_ERR_CANCELED = -4;

	public static final int GEN_LENGTH_MIN = 1;
	public static final int GEN_LENGTH_MAX = 255;
	// サイトスワップの種類
	public static final int SPT_NORMAL = 0x00;
	public static final int SPT_SYNCHRO = 0x01;
	public static final int SPT_ALL = (SPT_NORMAL | SPT_SYNCHRO);
	
	private GenPattern gen;
	private int mode;
	private int balls;
	private int height;
	private String period;
	private int maxPattern;
	private List<String> list = new ArrayList<String>();;
	private boolean isCancel = false;
	
	public MainGen(GenPattern gen, int mode, int balls, int height, String period, int maxPattern){
		this.gen = gen;
		this.mode = mode;
		this.balls = balls;
		this.height = height;
		this.period = period;
		this.maxPattern = maxPattern;
	}
	
	public List<String> generateSiteswap(){
		GenProc gs = new GenProc(this);
		gs.setMode(mode);
		gs.setHeight(height);
		
		list = new ArrayList<String>();
		char[] p = StdLib.stoc(period);
		
		int count = GetSiteswap(gs, list, balls, p);
		return list;
	}
	
	private int GetSiteswap(GenProc pgs, List<String> list, int balls, char[] sLength){
		int[] pdwLen;
		
	    //char[] sLength = new char[StdLib.BUFFLEN];
	    char[] sSeed = new char[StdLib.BUFFLEN];
	    //char[] sClass = new char[StdLib.BUFFLEN];
	    char[] sBuff = new char[StdLib.BUFFLEN];
	    
	    int i;
	    int j;
	    int iMax;
	    int iSize;
	    int iCount;
	    int iLen;
	    int iSeed;
	    int iStart;
	    int iEnd;
		
	    sSeed[0] = '\0';	    
	    iSeed = MainJudge.GetSiteswapCycle(sSeed);
	    
	    iMax = maxPattern;

	    // 周期を表す整数配列の作成
	    iLen = StringEx.TextToIntArray(sLength, null, 0, true);
	    if(iLen < 0)
	        return GEN_ERR_UNKNOWN;
	    pdwLen = new int[iLen];
	    //if(!pdwLen)
	    //    return GEN_ERR_MALLOC;
	    StringEx.TextToIntArray(sLength, pdwLen, iLen, true);

	    // サイトスワップ生成
	    iCount = 0;
	    //for(i = 0; i < iLen && iCount < iMax && !(*pbStop); i++){
		for(i = 0; i < iLen && iCount < iMax && !isCancel(); i++){
	        iStart = (int)StdLib.LOWORD(pdwLen[i]);
	        iEnd   = (int)StdLib.HIWORD(pdwLen[i]);
	        // 周期の妥当性チェック
	        if(iStart < GEN_LENGTH_MIN)
	            iStart = GEN_LENGTH_MIN;
	        if(iEnd > GEN_LENGTH_MAX)
	            iEnd = GEN_LENGTH_MAX;
	        if(iEnd < iStart)
	            iEnd = iStart;
	        if(iStart > GEN_LENGTH_MAX || iEnd < GEN_LENGTH_MIN)
	            break;
	        //for(j = iStart; j <= iEnd && iCount < iMax && !(*pbStop); j++){
		    for(j = iStart; j <= iEnd && iCount < iMax && !isCancel(); j++){
		    	// 速度アップのため追加(ボールの個数と高さが同じ場合)
		    	if (balls == height){
			    	if (mode == MainGen.SPT_NORMAL){
			    		if (j != 1){
			    			continue;
			    		}
			    	}
			    	else if (mode == MainGen.SPT_SYNCHRO){
			    		if (j != 2){
			    			continue;
			    		}			    		
			    	}
		    	}
		    	
	            //pgs->Length = j;
	            //pgs->Cancel = pbStop;
		    	pgs.init(balls, j);
	            if(j == iSeed)
	                StdLib.strcpy(sBuff, sSeed);
	            else
	                sBuff[0] = '\0';
	            if(j < iSeed)
	                continue;
	            //iSize = InitGenerator(pgs, sBuff);
	            iSize = pgs.InitGenerator(sBuff);
            	Debug.d(this, "InitGenerator " + j);
            	
	            // パターンを1つずつ生成
	            //while(iSize > 0 && iCount < iMax && !(*pbStop)){
		        while(iSize > 0 && iCount < iMax && !isCancel()){
	                if(iSize >= StdLib.BUFFLEN){
	                    //free(pdwLen);
	                	pdwLen = null;
	                    return GEN_ERR_BUFFSIZE;
	                }
	                // リストボックスに格納
	                //if(SendMessage(hList, LB_ADDSTRING, 0, (LPARAM)sBuff) == LB_ERRSPACE || SendMessage(hName, LB_ADDSTRING, 0, (LPARAM)sBuff) == LB_ERRSPACE){
	                //    free(pdwLen);
	                //    return GEN_ERR_MALLOC;
	                //}
	                String item = StdLib.ctos(sBuff);
	                list.add(item);
	                
	                iSize = pgs.EnumSiteswap(sBuff);
	                iCount++;
	                //SendMessage(ghWndMain, WM_USER_GEN, SSN_ADDSITESWAP, (LPARAM)iCount);

	                if ((iCount % 100) == 0){
	                	Debug.d(this, "GetSiteswap " + iCount);
	                }
		        }
	        }
	    }
		
	    return iCount;
	}

	public boolean isCancel() {
		return isCancel;
	}

	public void setCancel(boolean isCancel) {
		this.isCancel = isCancel;
	}

	@Override
	public void doExecute() {
		generateSiteswap();

		if (isCancel){
			return;
		}
		try {
			int type = 7;
			int size = list.size();
			JmPattern[] patterns = new JmPattern[size];
			for (int i = 0; i < size; i++) {
				String siteswap = list.get(i);
				JmPattern pattern = new JmPattern(type, siteswap, siteswap);
				patterns[i] = pattern;
			}

			// インテント経由だと重すぎるので
			Menu2.setList(patterns);

			// メモリ不足回避
			list = null;
			System.gc();			
		}
		catch (java.lang.OutOfMemoryError e){
			Debug.d(this, null, e);
			isCancel = true;
		}
		catch (RuntimeException e){
			Debug.d(this, null, e);
			isCancel = true;
		}
	}

	@Override
	public void cancel() {
		setCancel(true);
	}

	@Override
	public void done(boolean isCancel) {
		gen.createDone(isCancel);
	}
}
