package org.junitdoc.core.rewriter;

import java.util.List;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.junitdoc.ui.Const;

public class NewDecisionTableHandler extends RewriteHandlerAdapter {

	private String name;

	public NewDecisionTableHandler(String name) {
		this.name = name;
	}

	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		TypeDeclaration type = ASTUtils.findFirstTypeDeclaration(node);

		AST ast = node.getAST();

		// declare decisioTable annotation
		ListRewrite listRewrite = rewrite.getListRewrite(type,
				TypeDeclaration.BODY_DECLARATIONS_PROPERTY);

		AnnotationTypeDeclaration decisionTableAnno = ast
				.newAnnotationTypeDeclaration();
		decisionTableAnno.setName(ast.newSimpleName(name));
		decisionTableAnno.modifiers().add(
				ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));

		listRewrite.insertFirst(decisionTableAnno, null);

		// declare condition annotation
		listRewrite = rewrite.getListRewrite(decisionTableAnno,
				AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY);

		AnnotationTypeDeclaration conditionAnno = ast
				.newAnnotationTypeDeclaration();
		conditionAnno.setName(ast.newSimpleName(Const.CONDITION_TAG));
		// conditionAnno.modifiers().add(
		// ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));

		listRewrite.insertLast(conditionAnno, null);

		// declare action annotation
		AnnotationTypeDeclaration actionAnno = ast
				.newAnnotationTypeDeclaration();
		actionAnno.setName(ast.newSimpleName(Const.ACTION_TAG));
		// actionAnno.modifiers().add(
		// ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));

		listRewrite.insertLast(actionAnno, null);

		// create @Documet
		listRewrite = rewrite.getListRewrite(decisionTableAnno,
				AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);

		MarkerAnnotation marker = ast.newMarkerAnnotation();
		marker.setTypeName(ast.newName(Const.DECISIONTABLE_ANNOTATION));

		listRewrite.insertFirst(marker, null);

		// create import java.lang.annotation.Documented if necessary.
		if (!hasAnnotationImport(node)) {
			ImportDeclaration newImportDeclaration = ast.newImportDeclaration();
			newImportDeclaration.setName(ast
					.newName(Const.DECISIONTABLE_FULL_ANNOTATION));

			listRewrite = rewrite.getListRewrite(node,
					CompilationUnit.IMPORTS_PROPERTY);
			listRewrite.insertFirst(newImportDeclaration, null);
		}
	}

	private boolean hasAnnotationImport(ASTNode node) {
		return ASTUtils.hasImportDeclaration(node,
				Const.DECISIONTABLE_FULL_ANNOTATION);
	}
}
