﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Collections;
using System.Windows.Forms;
using System.Linq;
using System.Text;


namespace カブラウザもどき
{
    class Utils
    {
        /**
         * className に該当する、最初に見つかった要素を返す
         */
        public static HtmlElement GetElementByClassName(HtmlElement elms, string className)
        {
            HtmlElement elm = null;
            foreach (HtmlElement e in elms.All) {
                if (e.GetAttribute("className") == className) {
                    elm = e;
                    break;
                }
            }
            return elm;
        }
        /**
         * className に該当する、最初に見つかった要素を返す
         */
        public static HtmlElement GetElementByClassName(HtmlElement elms, string className, string tagName)
        {
            HtmlElement elm = null;
            HtmlElementCollection childs = elms.GetElementsByTagName(tagName);
            foreach (HtmlElement e in childs) {
                if (e.GetAttribute("className") == className) {
                    elm = e;
                    break;
                }
            }
            return elm;
        }

        /// <summary>
        /// xxxx.datファイルを重複を除いて、降順にソートする
        /// </summary>
        /// <param name="path"></param>
        public static void SortUniqTitleList(string path)
        {

            IDictionary dic = new Dictionary<int, string>();
            List<KeyValuePair<int, string>> list;
            // 保存したメッセージ一覧をsort & uniqする
            using (StreamReader sr = new StreamReader(path)) {
                StringReader tmp = new StringReader(sr.ReadToEnd());

                string[] splittedline;
                sr.Close();
                string line;
                while ((line = tmp.ReadLine()) != null) {
                    splittedline = line.Split(Form1.delimiter);
                    dic[int.Parse(splittedline[0])] = line;
                }

                list = SortByKey((Dictionary<int, string>)dic);

                StreamWriter sw = new StreamWriter(path);
                sw.Write("");
                foreach (KeyValuePair<int, string> tmpLine in list) {
                    sw.WriteLine(tmpLine.Value);
                }
                sw.Close();
                return;
            }
        }

        /// <summary>
        /// 連想配列のリストをキーでソートする
        /// </summary>
        /// <param name="dic"></param>
        /// <returns></returns>
        public static List<KeyValuePair<int, string>> SortByKey(Dictionary<int, string> dic)
        {
            List<KeyValuePair<int, string>> list = new List<KeyValuePair<int, string>>(dic);
            list.Sort(
              delegate(KeyValuePair<int, string> kvp1, KeyValuePair<int, string> kvp2)
              {
                  return kvp2.Key - kvp1.Key;
              });
            return list;
        }
    }
}
