﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace カブラウザもどき
{
    /// <summary>
    /// カブラウザもどきの設定クラス
    /// </summary>
    public partial class SettingForm : Form
    {
        private Form1 parent = null;
        private string nowSkin = "";
        public string needEdinetDoc = "";
        public SettingForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="execMode">動作モード(0:通常, 1:上級)</param>
        /// <param name="edi">EDINET提出書類(カンマ区切り)</param>
        public SettingForm(int execMode,  string edi, Form1 parent)
        {
            string [] edilist ;
            InitializeComponent();

            if (execMode == 0)
            {
                this.radioButton1.Checked = true;
            }
            else
            {
                this.radioButton2.Checked = true;
            }
            // EDINET書類一覧
            edilist = edi.Split(',');
            foreach (string tmp in edilist)
            {
                if (tmp != null && tmp != "")
                {
                    Control.ControlCollection t = this.tabPage2.Controls;
                    for (int j = 0; j < t.Count; j++) {
                        if (t[j].Text == tmp) {
                            ((CheckBox)(t[j])).Checked = true;
                        }
                    }
                }
            }

            // スキン一覧
            string [] files = Directory.GetFiles(".\\skin\\") ;
            // skin
            StringBuilder sb = new StringBuilder(1024);
            IniFileHandler.GetPrivateProfileString("Application", "Skin", "sample.html", sb, (uint)sb.Capacity, Form1.csIniFile);
            string now = sb.ToString();
            for ( int i=0; i < files.Length; i++) {
                if (files[i].IndexOf(".html") != -1) {
                    files[i] = files[i].Substring(7);
                    this.comboBox1.Items.Add(files[i]);
                    if (files[i] == now) {
                        this.comboBox1.SelectedIndex = i;
                        nowSkin = this.comboBox1.SelectedItem.ToString();
                    }
                }
            }

            // 自動ログイン情報
            IniFileHandler.GetPrivateProfileString("YahooID", "UserId", "", sb, (uint)sb.Capacity, Form1.csIniFile); 
            this.textBox1.Text = sb.ToString();
            IniFileHandler.GetPrivateProfileString("YahooID", "Password", "", sb, (uint)sb.Capacity, Form1.csIniFile);
            this.textBox2.Text = sb.ToString();

            this.parent = parent;
            this.textBox2.PasswordChar = '*';
        }

        /**
         * 上級タブの設定ボタン 
         */
        private void button1_Click(object sender, EventArgs e)
        {
            int i = 1;
            string edilist = "";

            foreach (Control item in this.tabPage2.Controls)
            {
                if (item.GetType().Equals(typeof(CheckBox)))
                {
                    IniFileHandler.WritePrivateProfileString("EDINET", "GetDocument" + i, "", Form1.csIniFile);
                    i++;
                }
            }

            i = 1;
            foreach (Control item in this.tabPage2.Controls)
            {
                if (item.GetType().Equals(typeof(CheckBox)) )
                {
                    CheckBox c = (CheckBox)item;
                    if (c.Checked == true)
                    {
                        IniFileHandler.WritePrivateProfileString("EDINET", "GetDocument" + i, c.Text, Form1.csIniFile);
                        edilist += c.Text;
                        i++;
                    }
                    edilist += ",";
                }
            }
            needEdinetDoc = edilist;
            MessageBox.Show("kabu.iniに設定しました。");
            this.Dispose();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (this.radioButton1.Checked)
            {
                IniFileHandler.WritePrivateProfileString("Application", "ExecMode", "0", Form1.csIniFile);
            }
            else
            {
                IniFileHandler.WritePrivateProfileString("Application", "ExecMode", "1", Form1.csIniFile);
            }
            MessageBox.Show("kabu.iniに設定しました。レイアウトが変更されるため、\n反映させるにはアプリケーションを再起動してください");
            this.Dispose();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            string skin = this.comboBox1.SelectedItem.ToString();
            if ( nowSkin != ""  && skin != "") {
                parent.ReDisplayContents(skin);
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            string skin = this.comboBox1.SelectedItem.ToString();
            IniFileHandler.WritePrivateProfileString("Application", "Skin", skin, Form1.csIniFile);
            MessageBox.Show("設定しました。");
            this.Dispose();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            string user = "";
            string pass = "";
            user = this.textBox1.Text;
            pass = this.textBox2.Text;
            StringBuilder sb = new StringBuilder(1024);
            if (user != "" && pass != "") {
                IniFileHandler.WritePrivateProfileString("YahooID", "UserId", user, Form1.csIniFile);
                IniFileHandler.WritePrivateProfileString("YahooID", "Password", pass, Form1.csIniFile);
            } else if (user == "" && pass == "") {
                IniFileHandler.WritePrivateProfileString("YahooID", "UserId", "", Form1.csIniFile);
                IniFileHandler.WritePrivateProfileString("YahooID", "Password", "", Form1.csIniFile);
            }

            MessageBox.Show("kabu.iniに設定しました。");
            this.Dispose();
        }
    }
}
