﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace カブラウザもどき
{

    public class CRSSReadResults
    {
        public Int64 mItemNo = 0;
        public string mTitle = string.Empty;
        public string mLinkURL = string.Empty;
        public DateTime mDate = new DateTime();

        public CRSSReadResults(string title, string linkURL, string date)
        {
            this.mTitle = title;
            this.mLinkURL = linkURL;
            this.mDate = fncRSSdatestr2csDate(date);
        }
        private DateTime fncRSSdatestr2csDate(string datestr)
        {
            char[] sep = new char[] { 'T', '+' };
            string newdatestr = datestr.Split(sep)[0].Replace( '-', '/');
            string newtimestr = datestr.Split(sep)[1];
            return Convert.ToDateTime( newdatestr + " " + newtimestr);
        }
    }

    class CRssRead
    {
        private string mRssURL = string.Empty;
        private XmlDocument mXmlDoc = null;
        public List<CRSSReadResults> results = null;

        public CRssRead(string rssURL)
        {
            this.mRssURL = rssURL;
            this.mXmlDoc = new XmlDocument();
            this.mXmlDoc.Load(rssURL);
            this.results = this.getresults(this.mXmlDoc);
        }

        private List<CRSSReadResults> getresults(XmlDocument xmlDoc)
        {
            List<CRSSReadResults> ret = new List<CRSSReadResults>();
            //RSS XMLNS マネージャ設定
            XmlNamespaceManager nsmgr = new XmlNamespaceManager(xmlDoc.NameTable);
            nsmgr.AddNamespace("rss", "http://purl.org/dc/elements/1.1/");
            nsmgr.AddNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            nsmgr.AddNamespace("dc", "http://purl.org/dc/elements/1.1/");
            //nsmgr.AddNamespace("sy", "");

            //rdf:li コレクション作成
            XmlNodeList linodes = xmlDoc.SelectNodes("/rdf:RDF/rss:channel/rss:items/rdf:Seq/rdf:li", nsmgr);

            //items取得
            foreach (XmlNode node in linodes)
            {
                //resource属性がマッチするitemノード取得
                string strResource = node.Attributes["resource", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"].Value;

                XmlNode aboutItem = xmlDoc.SelectSingleNode("/rdf:RDF/rss:item[@rdf:about='" + strResource + "']", nsmgr);

                //item 項目取得
                if (aboutItem != null)
                {
                    XmlNode titleNode = aboutItem.SelectSingleNode("rss:title", nsmgr);
                    XmlNode linkUrkNode = aboutItem.SelectSingleNode("rss:link", nsmgr);
                    XmlNode dateNode = aboutItem.SelectSingleNode("dc:date", nsmgr);

                    string title = string.Empty;
                    string link = string.Empty;
                    string dat = string.Empty;

                    if (titleNode != null)
                    {
                        title = titleNode.InnerText;
                    }
                    if (linkUrkNode != null)
                    {
                        link = linkUrkNode.InnerText;
                    }
                    if (dateNode != null)
                    {
                        dat = dateNode.InnerText;
                    }

                    ret.Add(new CRSSReadResults(title, link, dat));
                }
            }
            return ret;
        }
    }
}
