﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Diagnostics;

namespace カブラウザもどき
{
    public partial class Form2 : Form
    {

        string[] COMBO_DATA = { "java" ,"c#"
                    ,"python"
                    ,"ruby"
        };
        string[] LINK_DATA  = {
                     "http://www.google.co.jp"
                    ,"http://www.yahoo.co.jp"
                    ,"http://www.goo.ne.jp"
                    ,"http://www.excite.co.jp"
        };

        Image[] IMAGE_DATA  = {
                     Image.FromFile("Resources/sample-image-01.jpg")
                    ,Image.FromFile("Resources/sample-image-02.jpg")
                    ,Image.FromFile("Resources/sample-image-03.jpg")
                    ,Image.FromFile("Resources/sample-image-04.jpg")
        };

        public Form2()
        {
            InitializeComponent();
            initLocal();
        }



        protected void initLocal()
        {
            //////////////////////////////////////////
            //
            // カラムオブジェクトを一つずつ生成し指定していきます.
            //

            dataGridView1 = new DataGridView();
            dataGridView1.Dock = DockStyle.Fill;
            dataGridView1.EditMode = DataGridViewEditMode.EditOnEnter;
            // ユーザによる行の追加を禁止.
            dataGridView1.AllowUserToAddRows = false;

            //
            // 1列目はテキストボックス(読み取り専用).
            //
            DataGridViewTextBoxColumn col1 = new DataGridViewTextBoxColumn();
            col1.HeaderText = "テキスト(読み取り専用)";
            col1.DefaultCellStyle.ForeColor = Color.Red;
            col1.DefaultCellStyle.BackColor = Color.Gray;
            // 読み取り専用
            col1.ReadOnly = true;
            // 自動サイズ調整.
            col1.AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;

            //
            // 2列目はチェックボックス.
            //
            DataGridViewCheckBoxColumn col2 = new DataGridViewCheckBoxColumn();
            col2.HeaderText = "チェックボックス";
            // 自動サイズ調整無し
            col2.AutoSizeMode = DataGridViewAutoSizeColumnMode.None;
            // 2ステートのチェックボックス
            col2.ThreeState = false;
            col2.FlatStyle = FlatStyle.Standard;

            //
            // 3列目はボタン.
            //
            // ボタンカラムの場合、行データにデータを指定する必要はない。
            //
            DataGridViewButtonColumn col3 = new DataGridViewButtonColumn();
            col3.HeaderText = "ボタン";
            col3.Text = "Push Me!";
            col3.AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            // 全てのセルに対して、同じボタンのテキストを適用するには以下のプロパティをtrueにする
            col3.UseColumnTextForButtonValue = true;

            //
            // 4列目はコンボボックス.
            //
            DataGridViewComboBoxColumn col4 = new DataGridViewComboBoxColumn();
            col4.HeaderText = "コンボボックス";
            col4.AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            col4.MaxDropDownItems = 3;
            // 補完モードをON
            col4.AutoComplete = true;
            col4.FlatStyle = FlatStyle.Standard;
            // コンボに表示する値を設定.
            col4.Items.AddRange(COMBO_DATA);

            //
            // 5列目はリンク.
            //
            // ボタンと同じくUseColumnTextForLinkValueがtrueの場合は、全セルの値が
            // Textと同じになります。
            //
            DataGridViewLinkColumn col5 = new DataGridViewLinkColumn();
            col5.HeaderText = "リンク";
            col5.UseColumnTextForLinkValue = false;
            col5.AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            // リンクの動作は、システムと同じにする.
            col5.LinkBehavior = LinkBehavior.SystemDefault;
            // 一度リンク先に移動したことがある場合、リンクの色を変えるかどうか
            col5.TrackVisitedState = true;
            col5.UseColumnTextForLinkValue = false;

            //
            // 6列目はイメージ.
            //
            DataGridViewImageColumn col6 = new DataGridViewImageColumn();
            col6.HeaderText = "イメージ";
            //
            // 残りの領域を埋めるよう、サイズ設定する.
            //
            col6.AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill;
            col6.Description = "サンプルイメージです。";
            // イメージの配置方法を設定.
            // (Streachはクライアント領域にあわせて表示する指定.)
            col6.ImageLayout = DataGridViewImageCellLayout.Stretch;

            //
            // ボタン押下イベントを設定(セルのクリックイベントはDataGridViewに追加する).
            //
            // (CheckBoxのクリックでもこのイベントは発生する.)
            //
            dataGridView1.CellContentClick += delegate(object sender, DataGridViewCellEventArgs e)
            {
                //
                // ボタンカラムかどうかを判断し、処理.
                //
                DataGridView grid = sender as DataGridView;

                if (grid.Columns[e.ColumnIndex] is DataGridViewButtonColumn)
                {
                    MessageBox.Show(string.Format("{0}行目のボタンが押下されました.", (e.RowIndex + 1)));
                }
            };

            //
            // リンク押下イベントを設定
            //
            dataGridView1.CellContentClick += delegate(object sender, DataGridViewCellEventArgs e)
            {
                //
                // リンクカラムの場合、IEで開く.
                //
                DataGridView grid = sender as DataGridView;

                if (grid.Columns[e.ColumnIndex] is DataGridViewLinkColumn)
                {
                    //
                    // 該当セルのデータを取得.
                    //
                    DataGridViewRow row = grid.Rows[e.RowIndex];
                    DataGridViewCell cell = row.Cells[e.ColumnIndex];

                    MessageBox.Show("ブラウザを起動します.");

                    Process.Start("IExplore.exe", cell.Value.ToString());
                }

            };

            //
            // 作成したカラムオブジェクトを追加.
            //
            dataGridView1.Columns.AddRange(
                    new DataGridViewColumn[]{
                         col1
                        ,col2
                        ,col3
                        ,col4
                        ,col5
                        ,col6
                    }
            );

            //
            // 行データを設定.
            //
            Random r = new Random();
            for (int i = 0; i < 10; i++)
            {
                dataGridView1.Rows.Add(
                         string.Format("readonly-text-{0}", i.ToString())
                        , ((r.Next(0, 10) % 2) == 0) ? true : false
                        , null
                        , COMBO_DATA[r.Next(0, 4)]
                        , LINK_DATA[r.Next(0, 4)]
                        , IMAGE_DATA[r.Next(0, 4)]
                );
            }

            Controls.Add(dataGridView1);

            Width = 630;
            Height = 300;
        }



        private void button1_Click(object sender, EventArgs e)
        {
            DataGridViewLinkColumn hypercol = new DataGridViewLinkColumn();

            string[] row = new string[] { "1", "Product 1", "test", "", "2002/10/01" };
            dataGridView1.Rows.Add(row);
            row = new string[] { "2", "Product 2", "test", "", "2002/10/01" };
            dataGridView1.Rows.Add(row);
            row = new string[] { "3", "Product 3", "test", "", "2002/10/01" };
            dataGridView1.Rows.Add(row);
            row = new string[] { "4", "Product 4", "test", "", "2002/10/01" };
            dataGridView1.Rows.Add(row);
        }
    }

}
