﻿using System;
using System.ComponentModel;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;

namespace カブラウザもどき
{
    class GetLinks
    {
        [STAThread]
        static void main()
        {
            NonDispBrowser ndb = new NonDispBrowser();
            ndb.NavigateAndWait("http://messages.yahoo.co.jp/bbs?action=topics&board=1005423&sid=1005423");

            HtmlDocument doc = ndb.Document;

            // リンク文字列とそのURLの列挙
            foreach (HtmlElement e in doc.GetElementsByTagName("A"))
            {

                string href = e.GetAttribute("href"); // HREF属性の値
                string text = e.InnerText; // リンク文字列

                if (!string.IsNullOrEmpty(href)
                    && !string.IsNullOrEmpty(text))
                {
                    text = text.Replace("\r\n", ""); // 改行文字の削除
                    Console.WriteLine(href);
                    Console.WriteLine(text);
                }
            }

        }

    }
}
