﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Twitter;
using Youryella.Windows.Forms;
using System.Xml;
using System.Net;
using System.IO;
using System.Windows.Media.Imaging;
using System.Threading;
using CustomUIControls;
using System.Timers;

namespace Kakuretter
{

    public partial class Form1 : Form
    {

        TaskbarNotifier taskbarNotifier1;

        public Form1()
        {
            InitializeComponent();
            var settings = Properties.Settings.Default;

            if (!string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                authToolStripMenuItem.Text = "認証解除(&A)";

                int ri = settings.ReplyInterval;
                timer1.Interval = ri;
                timer1.Enabled = settings.ReplyPopup;

                //タスクバーの初期設定
                taskbarNotifier1 = new TaskbarNotifier();
                Image skinImage = Properties.Resources.skin;
                Image closeImage = Properties.Resources.close;
                taskbarNotifier1.SetBackgroundBitmap(skinImage, Color.FromArgb(255, 0, 255));
                taskbarNotifier1.SetCloseBitmap(closeImage, Color.FromArgb(255, 0, 255), new Point(180, 8));
                taskbarNotifier1.TitleRectangle = new Rectangle(10, 9, 160, 25);
                taskbarNotifier1.ContentRectangle = new Rectangle(8, 30, 180, 68);
                taskbarNotifier1.TitleClick += new EventHandler(TitleClick);
                taskbarNotifier1.ContentClick += new EventHandler(ContentClick);
                taskbarNotifier1.CloseClick += new EventHandler(CloseClick);
            
            }

            this.Location = settings.MyLocation;
            this.Opacity = settings.Opacity;
            Form1.Form1Instance = this;
        }

        //Form1オブジェクトを保持するためのフィールド
        private static Form1 _form1Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form1 Form1Instance
        {
            get
            {
                return _form1Instance;
            }
            set
            {
                _form1Instance = value;
            }
        }

        private void textBox3_KeyDown_1(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == System.Windows.Forms.Keys.Enter)
            {

                // 設定ファイルから読み込む
                var settings = Properties.Settings.Default;
                if (settings.UserId == "")
                {
                    Form2 form2 = new Form2();
                    form2.Show();
                    return;
                }

                Dictionary<string, string> parameters = new Dictionary<string, string>();

                String text = textBox3.Text;
                textBox3.Text = "";
                if (textBox1.Text != "") text += " " + label1.Text + textBox1.Text;

                Auth auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                                settings.AccessToken, settings.AccessTokenSecret,
                                settings.UserId, settings.ScreenName);
                parameters.Add("status", auth.UrlEncode(text));
                auth.Post("http://api.twitter.com/1/statuses/update.xml", parameters);

            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            String text = textBox3.Text;
            textBox3.Text = "";

            Dictionary<string, string> parameters = new Dictionary<string, string>();

            if (textBox1.Text != "") text += " #" + textBox1.Text;
            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            Auth auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                            settings.AccessToken, settings.AccessTokenSecret,
                            settings.UserId, settings.ScreenName);
            parameters.Add("status", auth.UrlEncode(text));
            auth.Post("http://api.twitter.com/1/statuses/update.xml", parameters);

        }

        private void 認証ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]))
            {
                settings.AccessToken = "";
                settings.AccessTokenSecret = "";
                settings.UserId = "";
                settings.ScreenName = "";
                settings.Save();
                authToolStripMenuItem.Text = "認証する(&A)";
            }
            else
            {
                Form2 form2 = new Form2();
                form2.Show();
            }
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            int tl = 140 - this.textBox3.TextLength;
            this.label2.Text = tl.ToString();
        }

        private void 隠れるToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.WindowState = System.Windows.Forms.FormWindowState.Minimized;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void Form1_ClientSizeChanged(object sender, EventArgs e)
        {
            if (this.WindowState == System.Windows.Forms.FormWindowState.Minimized)
            {
                // フォームが最小化の状態であればフォームを非表示にする  
                this.Hide();

                // トレイリストのアイコンを表示する
                notifyIcon1.Icon = new Icon(this.Icon, 40, 40);
                notifyIcon1.Visible = true;
            }
        }

        private void notifyIcon1_Click(object sender, EventArgs e)
        {


        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason != CloseReason.ApplicationExitCall)
            {
                e.Cancel = true;
                // フォームが最小化の状態であればフォームを非表示にする  
                this.Hide();

                // トレイリストのアイコンを表示する
                notifyIcon1.Icon = new Icon(this.Icon, 40, 40);
                notifyIcon1.Visible = true;
            }
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {

        }

        private void 終了ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;

            var settings = Properties.Settings.Default;
            settings.MyLocation = this.Location;
            settings.Save();

            Application.Exit();
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                // フォームを表示する  
                this.Visible = true;
                // 現在の状態が最小化の状態であれば通常の状態に戻す  
                if (this.WindowState == FormWindowState.Minimized)
                {
                    this.WindowState = FormWindowState.Normal;
                }
                // フォームをアクティブにする  
                this.Activate();
            }
        }

        private void 設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form3 form3 = new Form3();
            form3.Show();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        void CloseClick(object obj, EventArgs ea)
        {
            MessageBox.Show("Closed was Clicked");
        }

        void TitleClick(object obj, EventArgs ea)
        {
            MessageBox.Show("Title was Clicked");
        }

        void ContentClick(object obj, EventArgs ea)
        {
            MessageBox.Show("Content was Clicked");
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            if (string.IsNullOrEmpty((string)settings["AccessToken"])) return;
            taskbarNotifier1.CloseClickable = true;
            taskbarNotifier1.TitleClickable = false;
            taskbarNotifier1.ContentClickable = true;
            taskbarNotifier1.EnableSelectionRectangle = true;
            taskbarNotifier1.KeepVisibleOnMousOver = true;	// Added Rev 002
            taskbarNotifier1.ReShowOnMouseOver = true;			// Added Rev 002
            taskbarNotifier1.EnableSelectionRectangle = false;

            Dictionary<string, string> parameters = new Dictionary<string, string>();
            parameters.Add("count", "30");

            Auth auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                            settings.AccessToken, settings.AccessTokenSecret,
                            settings.UserId, settings.ScreenName);
            string a = auth.Get("http://api.twitter.com/1/statuses/mentions.xml", parameters);
            XmlDocument xd = new XmlDocument();
            xd.LoadXml(a);
            XmlElement xe = xd.DocumentElement;
            XmlNodeList xnl = xe.GetElementsByTagName("name");
            XmlNodeList xnl2 = xe.GetElementsByTagName("text");
            //XmlNodeList xnl3 = xe.GetElementsByTagName("profile_image_url");
            XmlNodeList xnl4 = xe.GetElementsByTagName("created_at");

            for (int i = 0; i < xnl.Count; i++)
            {
                DateTime dt = datetimeParceTwitter(xnl4.Item(i).InnerText);
                dt = dt.AddMilliseconds(timer1.Interval);
                DateTime now = DateTime.Now;
                if (now < dt)
                {
                    taskbarNotifier1.Show(xnl.Item(i).InnerText, xnl2.Item(i).InnerText, 500, 10000, 500);
                }
                else
                {
                    break;
                }

            }
        }

        private DateTime datetimeParceTwitter(string created_at)
        {
            string convertStr = "ddd MMM dd HH':'mm':'ss zz'00' yyyy";
            DateTime dt = DateTime.ParseExact(created_at, convertStr,
                System.Globalization.DateTimeFormatInfo.InvariantInfo,
                System.Globalization.DateTimeStyles.None);
            return dt;
        }

        private void label1_Click(object sender, EventArgs e)
        {
            if (label1.Text == "#")
            {
                label1.Text = "@";
            }
            else
            {
                label1.Text = "#";
            }

        }

        private void 設定OToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form3 form3 = new Form3();
            form3.Show();
        }

    }
}
