#!/bin/sh
#
# This file is part of Karesansui.
#
# Copyright (C) 2009 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

echo -n "Really??"
read
read

#########################
# その他のパッケージのアンインストール

for pkgname in `cat <<_EOT_
hde-jquery-ui
hde-jquery
hde-virt-manager
hde-python-virtinst
winpdb
wxPython-common-gtk2-unicode
wxPython2.8-gtk2-unicode
python-crypto
_EOT_`
do
  rpm -q ${pkgname} >/dev/null 2>&1 && yum remove ${pkgname}
done

#########################
# 開発環境のアンインストール

# perl-Errorをアンインストール
rpm -e perl-Error

for pkgname in `cat <<_EOT_
hde-graphviz-gd
hde-graphviz
hde-libvirt-devel
hde-python-epydoc
hde-python-Beaker
hde-python-Babel
hde-python-setuptools
emacs-Pymacs
emacs-epydoc
emacs-js2
emacs-python-mode
emacs-yasnippet
perl-Git
git
_EOT_`
do
  rpm -q ${pkgname} >/dev/null 2>&1 && yum remove ${pkgname}
done

# gitリポジトリから取り寄せ
if [ -e /opt/karesansui/lib/python/karesansui ]; then
  rm -f /opt/karesansui/lib/python/karesansui
fi

#########################
# Karesansuiのインストール

/etc/init.d/hde-libvirtd stop
/etc/init.d/hde-lighttpd stop

rpm -e karesansui-release
rm -f /etc/yum.repos.d/karesansui*

for pkgname in `cat <<_EOT_
hde-python-Mako
hde-python-psycopg2
hde-python-SQLAlchemy
hde-python-simplejson
hde-python-flup
hde-python-webpy
hde-libvirt-python
hde-libvirt
hde-lighttpd
hde-openssl098
_EOT_`
do
  rpm -q ${pkgname} >/dev/null 2>&1 && yum remove ${pkgname}
done

rm -rf /etc/opt/karesansui
rm -rf /var/opt/karesansui
rm -rf /var/log/karesansui
